"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfraMetricsClient = getInfraMetricsClient;
var _ui_settings_keys = require("@kbn/observability-plugin/common/ui_settings_keys");
var _exclude_tiers_query = require("@kbn/observability-utils-common/es/queries/exclude_tiers_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getInfraMetricsClient({
  libs,
  context,
  request
}) {
  const {
    framework
  } = libs;
  const infraContext = await context.infra;
  const {
    uiSettings
  } = await context.core;
  const excludedDataTiers = await uiSettings.client.get(_ui_settings_keys.searchExcludedDataTiers);
  const metricsIndices = await infraContext.getMetricsIndices();
  const excludedQuery = excludedDataTiers.length ? (0, _exclude_tiers_query.excludeTiersQuery)(excludedDataTiers)[0].bool.must_not : [];
  return {
    search(searchParams) {
      var _searchParams$query$b, _searchParams$query, _searchParams$query$b2, _searchParams$query2;
      const searchFilter = (_searchParams$query$b = (_searchParams$query = searchParams.query) === null || _searchParams$query === void 0 ? void 0 : (_searchParams$query$b2 = _searchParams$query.bool) === null || _searchParams$query$b2 === void 0 ? void 0 : _searchParams$query$b2.must_not) !== null && _searchParams$query$b !== void 0 ? _searchParams$query$b : [];

      // This flattens arrays by one level, and non-array values can be added as well, so it all
      // results in a nice [QueryDsl, QueryDsl, ...] array.
      const mustNot = [].concat(searchFilter, excludedQuery);
      return framework.callWithRequest(context, 'search', {
        ...searchParams,
        ignore_unavailable: true,
        index: metricsIndices,
        query: {
          ...searchParams.query,
          bool: {
            ...((_searchParams$query2 = searchParams.query) === null || _searchParams$query2 === void 0 ? void 0 : _searchParams$query2.bool),
            must_not: mustNot
          }
        }
      }, request);
    }
  };
}