"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validGroupByForContext = exports.termsAggField = exports.shouldTermsAggOnContainer = exports.hasAdditionalContext = exports.getMetricsViewInAppUrlWithSpaceId = exports.getInventoryViewInAppUrlWithSpaceId = exports.getContextForRecoveredAlerts = exports.getAlertDetailsPageEnabledForApp = exports.flattenAdditionalContext = exports.doFieldsExist = exports.createScopedLogger = exports.UNGROUPED_FACTORY_KEY = exports.NUMBER_OF_DOCUMENTS = exports.KUBERNETES_POD_UID = void 0;
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _parse_technical_fields = require("@kbn/rule-registry-plugin/common/parse_technical_fields");
var _fieldTypes = require("@kbn/field-types");
var _objectUtils = require("@kbn/object-utils");
var _alert_link = require("../../../../common/alerting/metrics/alert_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_CONTEXT_CONTAINER = 'container';
const ALERT_CONTEXT_ORCHESTRATOR = 'orchestrator';
const ALERT_CONTEXT_CLOUD = 'cloud';
const ALERT_CONTEXT_HOST = 'host';
const ALERT_CONTEXT_LABELS = 'labels';
const ALERT_CONTEXT_TAGS = 'tags';
const HOST_NAME = 'host.name';
const HOST_HOSTNAME = 'host.hostname';
const HOST_ID = 'host.id';
const CONTAINER_ID = 'container.id';
const SUPPORTED_ES_FIELD_TYPES = [_fieldTypes.ES_FIELD_TYPES.KEYWORD, _fieldTypes.ES_FIELD_TYPES.IP, _fieldTypes.ES_FIELD_TYPES.BOOLEAN];
const UNGROUPED_FACTORY_KEY = exports.UNGROUPED_FACTORY_KEY = '*';
const createScopedLogger = (logger, scope, alertExecutionDetails) => {
  const scopedLogger = logger.get(scope);
  const fmtMsg = msg => `[AlertId: ${alertExecutionDetails.alertId}][ExecutionId: ${alertExecutionDetails.executionId}] ${msg}`;
  return {
    ...scopedLogger,
    info: (msg, meta) => scopedLogger.info(fmtMsg(msg), meta),
    debug: (msg, meta) => scopedLogger.debug(fmtMsg(msg), meta),
    trace: (msg, meta) => scopedLogger.trace(fmtMsg(msg), meta),
    warn: (errorOrMessage, meta) => {
      if ((0, _lodash.isError)(errorOrMessage)) {
        scopedLogger.warn(errorOrMessage, meta);
      } else {
        scopedLogger.warn(fmtMsg(errorOrMessage), meta);
      }
    },
    error: (errorOrMessage, meta) => {
      if ((0, _lodash.isError)(errorOrMessage)) {
        scopedLogger.error(errorOrMessage, meta);
      } else {
        scopedLogger.error(fmtMsg(errorOrMessage), meta);
      }
    },
    fatal: (errorOrMessage, meta) => {
      if ((0, _lodash.isError)(errorOrMessage)) {
        scopedLogger.fatal(errorOrMessage, meta);
      } else {
        scopedLogger.fatal(fmtMsg(errorOrMessage), meta);
      }
    }
  };
};
exports.createScopedLogger = createScopedLogger;
const getAlertDetailsPageEnabledForApp = (config, appName) => {
  if (!config) return false;
  return config[appName].enabled;
};
exports.getAlertDetailsPageEnabledForApp = getAlertDetailsPageEnabledForApp;
const getInventoryViewInAppUrlWithSpaceId = ({
  criteria,
  nodeType,
  timestamp,
  hostName,
  assetDetailsLocator,
  inventoryLocator
}) => {
  const {
    metric,
    customMetric
  } = criteria[0];
  const fields = {
    [`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.criteria.metric`]: [metric],
    [`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.criteria.customMetric.id`]: [customMetric === null || customMetric === void 0 ? void 0 : customMetric.id],
    [`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.criteria.customMetric.aggregation`]: [customMetric === null || customMetric === void 0 ? void 0 : customMetric.aggregation],
    [`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.criteria.customMetric.field`]: [customMetric === null || customMetric === void 0 ? void 0 : customMetric.field],
    [_alert_link.ALERT_RULE_PARAMETERS_NODE_TYPE]: [nodeType],
    [_ruleDataUtils.TIMESTAMP]: timestamp,
    [HOST_NAME]: hostName
  };
  return (0, _alert_link.getInventoryViewInAppUrl)({
    fields: (0, _parse_technical_fields.parseTechnicalFields)(fields, true),
    assetDetailsLocator,
    inventoryLocator
  });
};
exports.getInventoryViewInAppUrlWithSpaceId = getInventoryViewInAppUrlWithSpaceId;
const getMetricsViewInAppUrlWithSpaceId = ({
  timestamp,
  groupBy,
  assetDetailsLocator,
  metricsExplorerLocator,
  additionalContext
}) => {
  const fields = {
    ...flattenAdditionalContext(additionalContext),
    [_ruleDataUtils.TIMESTAMP]: timestamp
  };
  return (0, _alert_link.getMetricsViewInAppUrl)({
    fields: (0, _parse_technical_fields.parseTechnicalFields)(fields, true),
    groupBy,
    assetDetailsLocator,
    metricsExplorerLocator
  });
};
exports.getMetricsViewInAppUrlWithSpaceId = getMetricsViewInAppUrlWithSpaceId;
const KUBERNETES_POD_UID = exports.KUBERNETES_POD_UID = 'kubernetes.pod.uid';
const NUMBER_OF_DOCUMENTS = exports.NUMBER_OF_DOCUMENTS = 10;
const termsAggField = exports.termsAggField = {
  [KUBERNETES_POD_UID]: CONTAINER_ID
};
const doFieldsExist = async (esClient, fields, index) => {
  // Get all supported fields
  const respMapping = await esClient.fieldCaps({
    index,
    fields
  });
  const fieldsExisted = {};
  const acceptableFields = new Set();
  Object.entries(respMapping.fields).forEach(([key, value]) => {
    const fieldTypes = Object.keys(value);
    const isSupportedType = fieldTypes.some(type => SUPPORTED_ES_FIELD_TYPES.includes(type));

    // Check if fieldName is something we can aggregate on
    if (isSupportedType) {
      acceptableFields.add(key);
    }
  });
  fields.forEach(field => {
    fieldsExisted[field] = acceptableFields.has(field);
  });
  return fieldsExisted;
};
exports.doFieldsExist = doFieldsExist;
const validGroupByForContext = exports.validGroupByForContext = [HOST_NAME, HOST_HOSTNAME, HOST_ID, KUBERNETES_POD_UID, CONTAINER_ID];
const hasAdditionalContext = (groupBy, validGroups) => {
  return groupBy ? Array.isArray(groupBy) ? groupBy.some(group => validGroups.includes(group)) : validGroups.includes(groupBy) : false;
};
exports.hasAdditionalContext = hasAdditionalContext;
const shouldTermsAggOnContainer = groupBy => {
  return groupBy && Array.isArray(groupBy) ? groupBy.includes(KUBERNETES_POD_UID) : groupBy === KUBERNETES_POD_UID;
};
exports.shouldTermsAggOnContainer = shouldTermsAggOnContainer;
const flattenAdditionalContext = additionalContext => {
  return additionalContext ? (0, _objectUtils.flattenObject)(additionalContext) : {};
};
exports.flattenAdditionalContext = flattenAdditionalContext;
const getContextForRecoveredAlerts = alertHitSource => {
  const alert = alertHitSource ? (0, _objectUtils.unflattenObject)(alertHitSource) : undefined;
  return {
    cloud: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_CLOUD],
    host: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_HOST],
    orchestrator: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_ORCHESTRATOR],
    container: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_CONTAINER],
    labels: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_LABELS],
    tags: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_TAGS]
  };
};
exports.getContextForRecoveredAlerts = getContextForRecoveredAlerts;