"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKbnUrlStateStorageFromRouterContext = exports.KbnUrlStateStorageFromRouterProvider = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKbnUrlStateStorageFromRouter = ({
  history,
  toastsService
}) => {
  const [urlStateStorage] = (0, _react.useState)(() => (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false,
    ...(0, _public.withNotifyOnErrors)(toastsService)
  }));
  return urlStateStorage;
};
const [KbnUrlStateStorageFromRouterProvider, useKbnUrlStateStorageFromRouterContext] = (0, _constate.default)(useKbnUrlStateStorageFromRouter);
exports.useKbnUrlStateStorageFromRouterContext = useKbnUrlStateStorageFromRouterContext;
exports.KbnUrlStateStorageFromRouterProvider = KbnUrlStateStorageFromRouterProvider;