"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceStateKeyInQueryString = exports.defaultLogViewKey = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _rison = require("@kbn/rison");
var _queryString = require("query-string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultLogViewKey = exports.defaultLogViewKey = 'logView';
const encodeRisonUrlState = state => (0, _rison.encode)(state);
const replaceStateKeyInQueryString = (stateKey, urlState) => queryString => {
  const previousQueryValues = (0, _queryString.parse)(queryString, {
    sort: false
  });
  const newValue = typeof urlState === 'undefined' ? previousQueryValues : {
    ...previousQueryValues,
    [stateKey]: encodeRisonUrlState(urlState)
  };
  return (0, _queryString.stringify)(_common.url.encodeQuery(newValue), {
    sort: false,
    encode: false
  });
};
exports.replaceStateKeyInQueryString = replaceStateKeyInQueryString;