"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateContentIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getColor = flag => flag ? 'primary' : 'hollow';
const TemplateContentIndicator = ({
  mappings,
  settings,
  aliases,
  contentWhenEmpty = null
}) => {
  if (!mappings && !settings && !aliases) {
    return contentWhenEmpty;
  }
  const texts = {
    settingsTrue: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.indexSettingsTrueLabel', {
      defaultMessage: 'This template contains index settings'
    }),
    settingsFalse: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.indexSettingsFalseLabel', {
      defaultMessage: 'This template does not contain index settings'
    }),
    mappingsTrue: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.indexMappingsTrueLabel', {
      defaultMessage: 'This template contains index mappings'
    }),
    mappingsFalse: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.indexMappingsFalseLabel', {
      defaultMessage: 'This template does not contain index mappings'
    }),
    aliasesTrue: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.indexAliasesTrueLabel', {
      defaultMessage: 'This template contains index aliases'
    }),
    aliasesFalse: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.indexAliasesFalseLabel', {
      defaultMessage: 'This template does not contain index aliases'
    })
  };
  const mappingsText = mappings ? texts.mappingsTrue : texts.mappingsFalse;
  const settingsText = settings ? texts.settingsTrue : texts.settingsFalse;
  const aliasesText = aliases ? texts.aliasesTrue : texts.aliasesFalse;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: mappingsText
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: getColor(mappings),
    "aria-label": mappingsText
  }, "M"), "\xA0")), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: settingsText
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: getColor(settings),
    "aria-label": settingsText
  }, "S"), "\xA0")), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: aliasesText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: getColor(aliases),
    "aria-label": aliasesText
  }, "A")));
};
exports.TemplateContentIndicator = TemplateContentIndicator;