"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConstantKeywordType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _lib = require("../../../../lib");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultToggleValue = (param, field) => {
  return field[param] !== undefined && field[param] !== (0, _lib.getFieldConfig)(param).defaultValue;
};
const ConstantKeywordType = ({
  field
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, null, /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.constantKeyword.valueFieldTitle', {
      defaultMessage: 'Set value'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.constantKeyword.valueFieldDescription', {
      defaultMessage: 'The value of this field for all documents in the index. If not specified, defaults to the value specified in the first document indexed.'
    }),
    defaultToggleValue: getDefaultToggleValue('value', field.source)
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "value",
    config: (0, _lib.getFieldConfig)('value'),
    component: _shared_imports.Field
  }))), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, null, /*#__PURE__*/_react.default.createElement(_field_parameters.MetaParameter, {
    defaultToggleValue: getDefaultToggleValue('meta', field.source)
  })));
};
exports.ConstantKeywordType = ConstantKeywordType;