"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageCard = PackageCard;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/usage-collection-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _deferred_assets_warning = require("../screens/detail/assets/deferred_assets_warning");
var _package_icon = require("../../../../../components/package_icon");
var _components = require("../../../components");
var _hooks = require("../../../hooks");
var _constants = require("../../../constants");
var _installation_status = require("./installation_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PackageCard({
  description,
  name,
  title,
  version,
  type,
  icons,
  integration,
  url,
  release,
  id,
  fromIntegrations,
  isReauthorizationRequired,
  isUnverified,
  isUpdateAvailable,
  showLabels = true,
  showInstallationStatus,
  showCompressedInstallationStatus,
  extraLabelsBadges,
  isQuickstart = false,
  installStatus,
  onCardClick: onClickProp = undefined,
  isCollectionCard = false,
  titleLineClamp,
  titleBadge,
  descriptionLineClamp,
  maxCardHeight,
  minCardHeight,
  showDescription = true,
  showReleaseBadge = true,
  hasDataStreams
}) {
  const theme = (0, _eui.useEuiTheme)();
  let releaseBadge = null;
  if (release && release !== 'ga' && showReleaseBadge) {
    releaseBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_components.InlineReleaseBadge, {
      release: release
    })));
  }
  let verifiedBadge = null;
  if (isUnverified && showLabels) {
    verifiedBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.unverifiedLabel",
      defaultMessage: "Unverified"
    }))));
  }
  let hasDeferredInstallationsBadge = null;
  if (isReauthorizationRequired && showLabels) {
    hasDeferredInstallationsBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "inlineBlock",
      content: _deferred_assets_warning.DEFERRED_ASSETS_WARNING_MSG,
      title: _deferred_assets_warning.DEFERRED_ASSETS_WARNING_LABEL,
      css: (0, _react2.css)`
              width: 100%;
            `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      tabIndex: 0
    }, _deferred_assets_warning.DEFERRED_ASSETS_WARNING_LABEL, ' '))));
  }
  let updateAvailableBadge = null;
  if (isUpdateAvailable && showLabels) {
    updateAvailableBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "sortUp"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.updateAvailableLabel",
      defaultMessage: "Update available"
    }))));
  }
  let collectionButton = null;
  if (isCollectionCard) {
    collectionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "text",
      "data-test-subj": "xpack.fleet.packageCard.collectionButton",
      iconType: "package"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.collectionButton.copy",
      defaultMessage: "View collection"
    })));
  }
  let contentBadge = null;
  if (type === 'content') {
    contentBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.contentPackageLabel",
      defaultMessage: "Content only"
    }))));
  }
  const {
    application
  } = (0, _hooks.useStartServices)();
  const isGuidedOnboardingActive = (0, _hooks.useIsGuidedOnboardingActive)(name);
  const onCardClick = () => {
    if (url.startsWith(_constants.INTEGRATIONS_BASE_PATH)) {
      application.navigateToApp(_constants.INTEGRATIONS_PLUGIN_ID, {
        path: url.slice(_constants.INTEGRATIONS_BASE_PATH.length),
        state: {
          fromIntegrations
        }
      });
    } else if (url.startsWith('http') || url.startsWith('https')) {
      window.open(url, '_blank');
    } else {
      application.navigateToUrl(url);
    }
  };
  const installationStatusVisible = (0, _installation_status.shouldShowInstallationStatus)({
    installStatus,
    showInstallationStatus,
    isActive: hasDataStreams
  });
  const testid = `integration-card:${id}`;
  return /*#__PURE__*/_react.default.createElement(_components.WithGuidedOnboardingTour, {
    packageKey: name,
    isTourVisible: isGuidedOnboardingActive,
    tourType: 'integrationCard',
    tourOffset: 10
  }, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: testid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard
  // EUI TODO: Custom component CSS
  // Min-height is roughly 3 lines of content.
  // This keeps the cards from looking overly unbalanced because of content differences.
  , {
    css: (0, _react2.css)`
            position: relative;
            [class*='euiCard__content'] {
              display: flex;
              flex-direction: column;
              block-size: 100%;
              overflow: hidden;
            }

            [class*='euiCard__description'] {
              flex-grow: 1;
              ${descriptionLineClamp ? installationStatusVisible ? (0, _installation_status.getLineClampStyles)(1) // Show only one line of description if installation status is shown
    : (0, _installation_status.getLineClampStyles)(descriptionLineClamp) : ''}
            }

            [class*='euiCard__titleButton'] {
              width: ${installationStatusVisible ? `calc(100% - ${theme.euiTheme.base * 4}px)` : '100%'};
              ${(0, _installation_status.getLineClampStyles)(titleLineClamp)}
            }

            min-height: ${minCardHeight ? `${minCardHeight}px` : '127px'};
            border-color: ${isQuickstart ? theme.euiTheme.colors.accent : null};
            max-height: ${maxCardHeight ? `${maxCardHeight}px` : null};
            overflow: ${maxCardHeight ? 'hidden' : null};
          `,
    "data-test-subj": testid,
    betaBadgeProps: quickstartBadge(isQuickstart),
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement(CardTitle, {
      title: title,
      titleBadge: titleBadge
    }),
    titleSize: "xs",
    description: showDescription ? description : '',
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_package_icon.CardIcon, {
      icons: icons,
      packageName: name,
      integrationName: integration,
      version: version,
      size: showDescription ? 'xl' : 'xxl'
    }),
    onClick: onClickProp !== null && onClickProp !== void 0 ? onClickProp : onCardClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true,
    css: (0, _react2.css)`
              width: ${installationStatusVisible ? `calc(100% - ${theme.euiTheme.base * 4}px)` : '100%'};
              overflow-x: hidden;
              text-overflow: ellipsis;
              & > .euiFlexItem {
                min-width: 0;
              }
              ${isCollectionCard ? `& > .euiFlexItem:last-child {
              min-width: auto;
            }` : ''}
            `
  }, showLabels && extraLabelsBadges ? extraLabelsBadges : null, verifiedBadge, updateAvailableBadge, contentBadge, releaseBadge, hasDeferredInstallationsBadge, collectionButton, /*#__PURE__*/_react.default.createElement(_installation_status.InstallationStatus, {
    installStatus: installStatus,
    showInstallationStatus: showInstallationStatus,
    compressed: showCompressedInstallationStatus,
    hasDataStreams: hasDataStreams
  })))));
}
const CardTitle = /*#__PURE__*/_react.default.memo(({
  title,
  titleBadge
}) => {
  if (!titleBadge) {
    return title;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, titleBadge));
});
function quickstartBadge(isQuickstart) {
  return isQuickstart ? {
    label: _i18n.i18n.translate('xpack.fleet.packageCard.quickstartBadge.label', {
      defaultMessage: 'Quickstart'
    }),
    color: 'accent'
  } : undefined;
}