"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentBinarySection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _download_source_table = require("../download_source_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentBinarySection = ({
  downloadSources,
  deleteDownloadSource
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const authz = (0, _hooks.useAuthz)();
  const hasAllSettingsPrivileges = authz.fleet.allSettings;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.downloadSourcesSection.Title",
    defaultMessage: "Agent Binary Download"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.downloadSourcesSection.Subtitle",
    defaultMessage: "List of sources used by Elastic agents to download their binaries. The default source applies to all agent policies that don't have a specific binary source specified."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_download_source_table.DownloadSourceTable, {
    downloadSources: downloadSources,
    deleteDownloadSource: deleteDownloadSource,
    hasAllSettingsPrivileges: hasAllSettingsPrivileges
  }), hasAllSettingsPrivileges && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    href: getHref('settings_create_download_sources'),
    "data-test-subj": "addDownloadSourcesBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.downloadSourcesSection.CreateButtonLabel",
    defaultMessage: "Add agent binary source"
  }))));
};
exports.AgentBinarySection = AgentBinarySection;