"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaTopics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputFormKafkaTopics = ({
  inputs
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const dynamicOptions = (0, _react.useMemo)(() => {
    const options = _constants.KAFKA_DYNAMIC_FIELDS.map(option => ({
      label: option,
      value: option
    }));
    return options;
  }, []);
  const renderTopics = () => {
    switch (inputs.kafkaTopicsInput.value) {
      case _constants.kafkaTopicsType.Static:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",
            defaultMessage: "Default topic"
          })
        }, inputs.kafkaStaticTopicInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaStaticTopicInput",
          fullWidth: true
        }, inputs.kafkaStaticTopicInput.props)));
      case _constants.kafkaTopicsType.Dynamic:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
          fullWidth: true,
          helpText: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicHelptext', {
            defaultMessage: 'Select a topic from the list. If a topic is not available, create a custom one.'
          }),
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicLabel",
            defaultMessage: "Topic from field(s). For more info, see our {guideLink}.",
            values: {
              guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                href: docLinks.links.fleet.kafkaOutputTopicsSettings,
                target: "_blank",
                external: true
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.fleet.settings.kafkaGuideLink",
                defaultMessage: "docs"
              }))
            }
          })
        }, inputs.kafkaDynamicTopicInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaDynamicTopicInput",
          fullWidth: true,
          isClearable: true,
          options: dynamicOptions,
          customOptionText: "Use custom field",
          singleSelection: {
            asPlainText: true
          }
        }, inputs.kafkaDynamicTopicInput.props)));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaTopicsPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaHeaders"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaTopcisTitle",
    defaultMessage: "Topics"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",
      defaultMessage: "Default topic"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, (0, _extends2.default)({
    style: {
      flexDirection: 'row',
      flexWrap: 'wrap',
      columnGap: 30
    },
    "data-test-subj": 'editOutputFlyout.kafkaTopicsRadioInput',
    options: _constants.kafkaTopicsOptions,
    compressed: true,
    name: "kafkaTopics"
  }, inputs.kafkaTopicsInput.props))), renderTopics(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.OutputFormKafkaTopics = OutputFormKafkaTopics;