"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaPartitioning = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kafkaPartitioningOptions = [{
  id: _constants.kafkaPartitionType.Random,
  label: 'Random',
  'data-test-subj': 'kafkaPartitionRandomRadioButton'
}, {
  id: _constants.kafkaPartitionType.RoundRobin,
  label: 'Round robin',
  'data-test-subj': 'kafkaPartitionRoundRobinRadioButton'
}, {
  id: _constants.kafkaPartitionType.Hash,
  label: 'Hash',
  'data-test-subj': 'kafkaPartitionHashRadioButton'
}];
const OutputFormKafkaPartitioning = props => {
  const {
    inputs
  } = props;
  const renderPartitioning = () => {
    switch (inputs.kafkaPartitionTypeInput.value) {
      case _constants.kafkaPartitionType.Random:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRandomInputLabel",
            defaultMessage: "Number of events"
          })
        }, inputs.kafkaPartitionTypeRandomInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaPartitionTypeRandomInput",
          fullWidth: true
        }, inputs.kafkaPartitionTypeRandomInput.props)));
      case _constants.kafkaPartitionType.RoundRobin:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRoundRobinInputLabel",
            defaultMessage: "Number of events"
          })
        }, inputs.kafkaPartitionTypeRoundRobinInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaPartitionTypeRoundRobinInput",
          fullWidth: true
        }, inputs.kafkaPartitionTypeRoundRobinInput.props)));
      case _constants.kafkaPartitionType.Hash:
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashInputLabel",
            defaultMessage: "List of fields"
          }),
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashHelpTextLabel",
            defaultMessage: "Comma separated."
          })
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaPartitionTypeHashInput",
          fullWidth: true
        }, inputs.kafkaPartitionTypeHashInput.props))));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaPartitionPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaPartitionTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitionTitle",
    defaultMessage: "Partitioning"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaPartitioningInputLabel",
      defaultMessage: "Partitioning strategy"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, (0, _extends2.default)({
    style: {
      flexDirection: 'row',
      flexWrap: 'wrap',
      columnGap: 30
    },
    "data-test-subj": 'settingsOutputsFlyout.kafkaPartitioningRadioInput',
    options: kafkaPartitioningOptions,
    compressed: true,
    name: "kafkaPartitioningStrategy"
  }, inputs.kafkaPartitionTypeInput.props))), renderPartitioning());
};
exports.OutputFormKafkaPartitioning = OutputFormKafkaPartitioning;