"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVERLESS_DEFAULT_FLEET_SERVER_HOST_ID = exports.SERVERLESS_AGENTLESS_FLEET_SERVER_HOST_ID = exports.PROXY_URL_REGEX = exports.FLEET_SERVER_HOST_SAVED_OBJECT_TYPE = exports.FLEET_PROXY_SAVED_OBJECT_TYPE = exports.ECH_AGENTLESS_FLEET_SERVER_HOST_ID = exports.DEFAULT_FLEET_SERVER_HOST_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FLEET_SERVER_HOST_SAVED_OBJECT_TYPE = exports.FLEET_SERVER_HOST_SAVED_OBJECT_TYPE = 'fleet-fleet-server-host';
const DEFAULT_FLEET_SERVER_HOST_ID = exports.DEFAULT_FLEET_SERVER_HOST_ID = 'fleet-default-fleet-server-host';
const FLEET_PROXY_SAVED_OBJECT_TYPE = exports.FLEET_PROXY_SAVED_OBJECT_TYPE = 'fleet-proxy';
const PROXY_URL_REGEX = exports.PROXY_URL_REGEX = /^(http[s]?|socks5):\/\/[^\s$.?#].[^\s]*$/gm;
const SERVERLESS_DEFAULT_FLEET_SERVER_HOST_ID = exports.SERVERLESS_DEFAULT_FLEET_SERVER_HOST_ID = 'default-fleet-server';

// Fleet Server IDs used for agentless policies:
//  - For ECH, this is created by Fleet, see `createCloudFleetServerHostsIfNeeded` in:
//    `x-pack/platform/plugins/shared/fleet/server/services/preconfiguration/fleet_server_host.ts`
//  - For Serverless, this is the `default-fleet-server` host that is created from
//    preconfiguration via project controller
//  - Both are uneditable by users due to having `is_preconfigured: true` set
const ECH_AGENTLESS_FLEET_SERVER_HOST_ID = exports.ECH_AGENTLESS_FLEET_SERVER_HOST_ID = 'internal-agentless-fleet-server';
const SERVERLESS_AGENTLESS_FLEET_SERVER_HOST_ID = exports.SERVERLESS_AGENTLESS_FLEET_SERVER_HOST_ID = SERVERLESS_DEFAULT_FLEET_SERVER_HOST_ID;