"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlLabel = ControlLabel;
exports.ControlType = ControlType;
exports.ControlWidth = ControlWidth;
exports.Footer = Footer;
exports.Header = Header;
exports.VariableName = VariableName;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _esqlTypes = require("@kbn/esql-types");
var _i18nReact = require("@kbn/i18n-react");
var _visualizationUtils = require("@kbn/visualization-utils");
var _eui = require("@elastic/eui");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const controlTypeOptions = [{
  label: _i18n.i18n.translate('esql.flyout.controlTypeOptions.staticValuesLabel', {
    defaultMessage: 'Static values'
  }),
  'data-test-subj': 'staticValues',
  key: _esqlTypes.EsqlControlType.STATIC_VALUES
}, {
  label: _i18n.i18n.translate('esql.flyout.controlTypeOptions.valuesFromQueryLabel', {
    defaultMessage: 'Values from a query'
  }),
  'data-test-subj': 'valuesFromQuery',
  key: _esqlTypes.EsqlControlType.VALUES_FROM_QUERY
}];
const minimumWidthButtonGroup = [{
  id: `small`,
  label: _i18n.i18n.translate('esql.flyout.minimumWidth.small', {
    defaultMessage: 'Small'
  })
}, {
  id: `medium`,
  label: _i18n.i18n.translate('esql.flyout.minimumWidth.medium', {
    defaultMessage: 'Medium'
  })
}, {
  id: `large`,
  label: _i18n.i18n.translate('esql.flyout.minimumWidth.large', {
    defaultMessage: 'Large'
  })
}];
function ControlType({
  isDisabled,
  initialControlFlyoutType,
  onFlyoutTypeChange
}) {
  const controlFlyoutType = controlTypeOptions.find(option => option.key === initialControlFlyoutType);
  const onTypeChange = (0, _react.useCallback)(selectedOptions => {
    const flyoutType = controlTypeOptions.find(option => option.key === selectedOptions[0].key);
    onFlyoutTypeChange === null || onFlyoutTypeChange === void 0 ? void 0 : onFlyoutTypeChange(flyoutType.key);
  }, [onFlyoutTypeChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('esql.flyout.controlTypeOptionsOptions.disabledTooltip', {
      defaultMessage: 'Currently, only the [Static values] type is available to replace functions or field names.'
    }),
    condition: isDisabled,
    anchorProps: {
      css: {
        width: '100%'
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.controlTypeOptionsOptions.label', {
      defaultMessage: 'Type'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('esql.flyout.controlTypeOptionsOptions.placeholder', {
      defaultMessage: 'Select a control type'
    }),
    placeholder: _i18n.i18n.translate('esql.flyout.controlTypeOptionsOptions.placeholder', {
      defaultMessage: 'Select a control type'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: controlTypeOptions,
    selectedOptions: [controlFlyoutType],
    onChange: onTypeChange,
    fullWidth: true,
    isDisabled: isDisabled,
    compressed: true,
    isClearable: false,
    "data-test-subj": "esqlControlTypeDropdown",
    inputPopoverProps: {
      'data-test-subj': 'esqlControlTypeInputPopover'
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}
function VariableName({
  variableName,
  isControlInEditMode,
  esqlVariables = [],
  onVariableNameChange
}) {
  const tooltipContent = _i18n.i18n.translate('esql.flyout.variableName.tooltipText', {
    defaultMessage: 'Start your control name with ? to replace values or with ?? to replace field names or functions.'
  });
  const helpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esql.flyout.variableName.helpText",
    defaultMessage: "Start your control name with {valuesPrefix} to replace {valuesBold} or with {fieldsPrefix} to replace {fieldsBold} or {functionsBold}.",
    values: {
      valuesPrefix: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "?"),
      fieldsPrefix: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "??"),
      valuesBold: /*#__PURE__*/_react.default.createElement("strong", null, "values"),
      fieldsBold: /*#__PURE__*/_react.default.createElement("strong", null, "fields"),
      functionsBold: /*#__PURE__*/_react.default.createElement("strong", null, "functions")
    }
  });
  const isDisabledTooltipText = _i18n.i18n.translate('esql.flyout.variableName.disabledTooltip', {
    defaultMessage: 'You can’t edit a control name after it’s been created.'
  });
  const variableNameWithoutQuestionmark = variableName.replace(/^\?+/, '');
  const variableExists = (0, _helpers.checkVariableExistence)(esqlVariables, variableName) && !isControlInEditMode;
  const errorMessage = !variableNameWithoutQuestionmark ? _i18n.i18n.translate('esql.flyout.variableName.error', {
    defaultMessage: 'Variable name is required'
  }) : variableExists ? _i18n.i18n.translate('esql.flyout.variableNameExists.error', {
    defaultMessage: 'Variable name already exists'
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.variableName.label', {
      defaultMessage: 'Name'
    }),
    helpText: helpText,
    fullWidth: true,
    autoFocus: true,
    isInvalid: !variableNameWithoutQuestionmark || variableExists,
    error: errorMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isControlInEditMode ? isDisabledTooltipText : tooltipContent,
    css: (0, _react2.css)`
          width: 100%;
        `,
    display: "block"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('esql.flyout.variableName.placeholder', {
      defaultMessage: 'Set a variable name'
    }),
    disabled: isControlInEditMode,
    value: variableName,
    onChange: onVariableNameChange,
    "aria-label": _i18n.i18n.translate('esql.flyout.variableName.placeholder', {
      defaultMessage: 'Set a variable name'
    }),
    "data-test-subj": "esqlVariableName",
    fullWidth: true,
    compressed: true,
    tabIndex: 0
  })));
}
function ControlLabel({
  label,
  onLabelChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.label.label', {
      defaultMessage: 'Label'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, _i18n.i18n.translate('esql.flyout.label.extraLabel', {
      defaultMessage: 'Optional'
    }))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('esql.flyout.label.placeholder', {
      defaultMessage: 'Set a label'
    }),
    value: label,
    onChange: onLabelChange,
    "aria-label": _i18n.i18n.translate('esql.flyout.label.placeholder', {
      defaultMessage: 'Set a label'
    }),
    "data-test-subj": "esqlControlLabel",
    fullWidth: true,
    compressed: true
  }));
}
function ControlWidth({
  minimumWidth,
  grow,
  onMinimumSizeChange,
  onGrowChange
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.minimumWidth.label', {
      defaultMessage: 'Minimum width'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('esql.flyout.minimumWidth.label', {
      defaultMessage: 'Minimum width'
    }),
    options: minimumWidthButtonGroup,
    idSelected: minimumWidth,
    onChange: id => onMinimumSizeChange(id),
    type: "single",
    isFullWidth: true,
    "data-test-subj": "esqlControlMinimumWidth"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('esql.flyout.grow.label', {
      defaultMessage: 'Expand width to fit available space'
    }),
    color: "primary",
    checked: grow !== null && grow !== void 0 ? grow : false,
    onChange: e => onGrowChange(e),
    "data-test-subj": "esqlControlGrow"
  }));
}
function Header({
  isInEditMode
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isInEditMode ? _i18n.i18n.translate('esql.flyout.editTitle', {
    defaultMessage: 'Edit ES|QL control'
  }) : _i18n.i18n.translate('esql.flyout.title', {
    defaultMessage: 'Create ES|QL control'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: _i18n.i18n.translate('esql.flyout.experimentalLabel.title', {
      defaultMessage: 'Technical preview'
    }),
    content: _i18n.i18n.translate('esql.flyout.experimentalLabel.content', {
      defaultMessage: 'ES|QL variables are currently on Technical preview.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "",
    iconType: "beaker",
    size: "s",
    tabIndex: 0,
    css: (0, _react2.css)`
                vertical-align: middle;
              `
  })))));
}
function Footer({
  isControlInEditMode,
  variableName,
  onCancelControl,
  isSaveDisabled,
  closeFlyout,
  onCreateControl
}) {
  const onCancel = (0, _react.useCallback)(() => {
    closeFlyout();
    onCancelControl === null || onCancelControl === void 0 ? void 0 : onCancelControl();
  }, [closeFlyout, onCancelControl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    id: "lnsCancelEditOnFlyFlyout",
    onClick: onCancel,
    flush: "left",
    "aria-label": _i18n.i18n.translate('esql.flyout..cancelFlyoutAriaLabel', {
      defaultMessage: 'Cancel applied changes'
    }),
    "data-test-subj": "cancelEsqlControlsFlyoutButton"
  }, _i18n.i18n.translate('esql.flyout.cancelLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onCreateControl,
    fill: true,
    "aria-label": _i18n.i18n.translate('esql.flyout..applyFlyoutAriaLabel', {
      defaultMessage: 'Apply changes'
    }),
    disabled: isSaveDisabled,
    color: "primary",
    iconType: "check",
    "data-test-subj": "saveEsqlControlsFlyoutButton"
  }, _i18n.i18n.translate('esql.flyout.saveLabel', {
    defaultMessage: 'Save'
  })))));
}