"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLegendSizeSelector = exports.TOP_MARGIN = exports.MARKER_WIDTH = exports.SCROLL_BAR_WIDTH = void 0;
const get_chart_theme_1 = require("./get_chart_theme");
const get_legend_config_selector_1 = require("./get_legend_config_selector");
const get_legend_items_1 = require("./get_legend_items");
const get_legend_table_size_1 = require("./get_legend_table_size");
const default_theme_attributes_1 = require("../../common/default_theme_attributes");
const legend_1 = require("../../common/legend");
const legend_item_1 = require("../../components/legend/legend_item");
const position_style_1 = require("../../components/legend/position_style");
const canvas_text_bbox_calculator_1 = require("../../utils/bbox/canvas_text_bbox_calculator");
const common_1 = require("../../utils/common");
const create_selector_1 = require("../create_selector");
const getParentDimensionSelector = (state) => state.parentDimensions;
exports.SCROLL_BAR_WIDTH = 16;
exports.MARKER_WIDTH = 16;
const SHARED_MARGIN = 4;
const VERTICAL_PADDING = 4;
exports.TOP_MARGIN = 2;
exports.getLegendSizeSelector = (0, create_selector_1.createCustomCachedSelector)([get_legend_config_selector_1.getLegendConfigSelector, get_chart_theme_1.getChartThemeSelector, getParentDimensionSelector, get_legend_items_1.getLegendItemsSelector], (config, theme, parentDimensions, items) => {
    const { showLegend, legendSize, legendValues, legendPosition, legendAction } = config;
    if (!showLegend) {
        return { width: 0, height: 0, margin: 0, position: position_style_1.LEGEND_TO_FULL_CONFIG[common_1.Position.Right] };
    }
    if ((0, legend_1.shouldDisplayTable)(legendValues)) {
        return (0, canvas_text_bbox_calculator_1.withTextMeasure)((textMeasure) => (0, get_legend_table_size_1.getLegendTableSize)(config, theme, parentDimensions, items, textMeasure));
    }
    const bbox = (0, canvas_text_bbox_calculator_1.withTextMeasure)((textMeasure) => items.reduce((acc, { label, depth, values }) => {
        const itemLabel = `${label}${legendValues.length > 0 ? values[0]?.label ?? '' : ''}`;
        const { width, height } = textMeasure(itemLabel, { fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY, fontVariant: 'normal', fontWeight: 400, fontStyle: 'normal' }, 12, 1.5);
        acc.width = Math.max(acc.width, width + depth * legend_item_1.LEGEND_HIERARCHY_MARGIN);
        acc.height = Math.max(acc.height, height);
        return acc;
    }, { width: 0, height: 0 }));
    const { legend: { verticalWidth, spacingBuffer, margin }, } = theme;
    const actionDimension = (0, common_1.isDefined)(legendAction) ? 24 : 0;
    const showExtraMargin = legendValues.length > 0;
    const legendItemWidth = exports.MARKER_WIDTH + SHARED_MARGIN + bbox.width + (showExtraMargin ? SHARED_MARGIN : 0);
    if (legendPosition.direction === common_1.LayoutDirection.Vertical) {
        const legendItemHeight = bbox.height + VERTICAL_PADDING * 2;
        const legendHeight = legendItemHeight * items.length + exports.TOP_MARGIN;
        const scrollBarDimension = legendHeight > parentDimensions.height ? exports.SCROLL_BAR_WIDTH : 0;
        const staticWidth = spacingBuffer + actionDimension + scrollBarDimension;
        const width = Number.isFinite(legendSize)
            ? Math.min(Math.max(legendSize, legendItemWidth * 0.3 + staticWidth), parentDimensions.width * 0.7)
            : Math.floor(Math.min(legendItemWidth + staticWidth, verticalWidth));
        return {
            width,
            height: legendHeight,
            margin,
            position: legendPosition,
        };
    }
    const isSingleLine = (parentDimensions.width - 20) / 200 > items.length;
    const height = Number.isFinite(legendSize)
        ? Math.min(legendSize, parentDimensions.height * 0.7)
        : isSingleLine
            ? bbox.height + 16
            : bbox.height * 2 + 24;
    return {
        height,
        width: Math.floor(Math.min(legendItemWidth + spacingBuffer + actionDimension, verticalWidth)),
        margin,
        position: legendPosition,
    };
});
//# sourceMappingURL=get_legend_size.js.map