"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringSampleDashboardsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _sample_dashboard = require("./components/sample_dashboard/sample_dashboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedUserMonitoringSampleDashboardsPanel = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "warning",
    hasBorder: false,
    paddingSize: "none",
    className: "test",
    css: (0, _react2.css)`
        border: ${euiTheme.border.width.thick} solid ${euiTheme.colors.warning};
      `
  }, /*#__PURE__*/_react.default.createElement(DashboardsSectionHeader, null), /*#__PURE__*/_react.default.createElement(_sample_dashboard.PrivilegedUserMonitoringSampleDashboard, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.PrivilegedUserMonitoringSampleDashboardsPanel = PrivilegedUserMonitoringSampleDashboardsPanel;
const DashboardsSectionHeader = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "warning",
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    css: (0, _react2.css)`
        position: sticky;
        top: 0;
        z-index: ${euiTheme.levels.header};
        top: var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0));
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    className: "eui-textCenter",
    textTransform: "uppercase"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.sampleDashboard.title",
    defaultMessage: "Sample Dashboard"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};