"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionViewAllAnomaliesButton = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _kibana = require("../../../../../common/lib/kibana");
var _use_global_time = require("../../../../../common/containers/use_global_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePadMlAnomalyExplorerUrl = () => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    services
  } = (0, _kibana.useKibana)();
  return (0, _public.useMlHref)(services.ml, services.http.basePath.get(), {
    page: _public.ML_PAGES.ANOMALY_EXPLORER,
    pageState: {
      jobIds: ['pad'],
      timeRange: {
        from,
        to
      },
      mlExplorerSwimlane: {
        viewByFieldName: 'user.name'
      }
    }
  }, [from, to]);
};
const PrivilegedAccessDetectionViewAllAnomaliesButton = () => {
  const anomalyExplorerUrl = usePadMlAnomalyExplorerUrl();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: 'primary',
    fill: false,
    iconType: 'anomalySwimLane'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: anomalyExplorerUrl,
    external: false,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.anomalyExplorer",
    defaultMessage: "View all in Anomaly Explorer"
  })));
};
exports.PrivilegedAccessDetectionViewAllAnomaliesButton = PrivilegedAccessDetectionViewAllAnomaliesButton;