"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntitiesListQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _api = require("../../../api/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_STORE_ENTITIES_LIST = 'ENTITY_STORE_ENTITIES_LIST';
const useEntitiesListQuery = params => {
  const {
    skip,
    ...fetchParams
  } = params;
  const {
    fetchEntitiesList
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useQuery)({
    queryKey: [ENTITY_STORE_ENTITIES_LIST, fetchParams],
    queryFn: () => fetchEntitiesList({
      params: fetchParams
    }),
    cacheTime: 0,
    enabled: !skip,
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
};
exports.useEntitiesListQuery = useEntitiesListQuery;