"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runDetectionMigrations = void 0;
var _migrate_alert_page_controls = require("../timelines/containers/local_storage/migrate_alert_page_controls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* Migrator could be sync or async */

const getLocalStorageMigrationRunner = (storage, plugins) => {
  const runLocalStorageMigration = async fn => {
    await fn(storage, plugins);
  };
  return runLocalStorageMigration;
};
const runDetectionMigrations = async (storage, plugins) => {
  const runLocalStorageMigration = getLocalStorageMigrationRunner(storage, plugins);
  await runLocalStorageMigration(_migrate_alert_page_controls.migrateAlertPageControlsTo816);
};
exports.runDetectionMigrations = runDetectionMigrations;