"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsViewerSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ITEMS_SCHEMA = {
  strict: true,
  fields: {
    created_by: {
      type: 'string'
    },
    description: {
      type: 'string'
    },
    id: {
      type: 'string'
    },
    item_id: {
      type: 'string'
    },
    list_id: {
      type: 'string'
    },
    name: {
      type: 'string'
    },
    os_types: {
      type: 'string'
    },
    tags: {
      type: 'string'
    }
  }
};
/**
 * Search exception items and take actions (to creat an item)
 */
const ExceptionsViewerSearchBarComponent = ({
  isReadOnly,
  isEndpoint,
  isSearching,
  onSearch,
  onAddExceptionClick
}) => {
  const handleOnSearch = (0, _react.useCallback)(({
    queryText
  }) => {
    onSearch({
      search: queryText
    });
  }, [onSearch]);
  const handleAddException = (0, _react.useCallback)(() => {
    onAddExceptionClick();
  }, [onAddExceptionClick]);
  const addExceptionButtonText = (0, _react.useMemo)(() => {
    return isEndpoint ? i18n.ADD_TO_ENDPOINT_LIST : i18n.ADD_TO_DETECTIONS_LIST;
  }, [isEndpoint]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      placeholder: i18n.SEARCH_PLACEHOLDER,
      incremental: true,
      schema: ITEMS_SCHEMA,
      'data-test-subj': 'exceptionsViewerSearchBar'
    },
    filters: [],
    onChange: handleOnSearch
  })), !isReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "exceptionsHeaderAddExceptionBtn",
    onClick: handleAddException,
    isDisabled: isSearching,
    fill: true
  }, addExceptionButtonText)));
};
ExceptionsViewerSearchBarComponent.displayName = 'ExceptionsViewerSearchBarComponent';
const ExceptionsViewerSearchBar = exports.ExceptionsViewerSearchBar = /*#__PURE__*/_react.default.memo(ExceptionsViewerSearchBarComponent);
ExceptionsViewerSearchBar.displayName = 'ExceptionsViewerSearchBar';