"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsViewer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _securitysolutionListApi = require("@kbn/securitysolution-list-api");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _use_endpoint_exceptions_capability = require("../../../../exceptions/hooks/use_endpoint_exceptions_capability");
var _user_info = require("../../../../detections/components/user_info");
var _kibana = require("../../../../common/lib/kibana");
var _search_bar = require("./search_bar");
var _reducer = require("./reducer");
var _pagination = require("./pagination");
var _utility_bar = require("./utility_bar");
var _all_items = require("./all_items");
var _edit_exception_flyout = require("../edit_exception_flyout");
var _add_exception_flyout = require("../add_exception_flyout");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_find_references = require("../../logic/use_find_references");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledText = (0, _styledComponents.default)(_eui.EuiText)`
  font-style: italic;
`;
const STATES_FILTERS_HIDDEN = ['error'];
const STATES_PAGINATION_UTILITY_HIDDEN = ['loading', 'empty_search', 'empty', 'error', 'searching'];
const initialState = {
  pagination: {
    pageIndex: 0,
    pageSize: 25,
    totalItemCount: 0,
    pageSizeOptions: [5, 10, 25, 50, 100, 200, 300]
  },
  exceptions: [],
  exceptionToEdit: null,
  currenFlyout: null,
  viewerState: 'loading',
  isReadOnly: true,
  lastUpdated: Date.now(),
  exceptionsToShow: {
    active: true
  }
};
const ExceptionsViewerComponent = ({
  rule,
  listTypes,
  isViewReadOnly,
  onRuleChange
}) => {
  const {
    services
  } = (0, _kibana.useKibana)();
  const toasts = (0, _kibana.useToasts)();
  const [{
    canUserCRUD,
    hasIndexWrite
  }] = (0, _user_info.useUserData)();
  const exceptionListsToQuery = (0, _react.useMemo)(() => rule != null && rule.exceptions_list != null ? rule.exceptions_list.filter(({
    type
  }) => listTypes.includes(type)) : [], [listTypes, rule]);
  const exceptionListsFormattedForReferenceQuery = (0, _react.useMemo)(() => exceptionListsToQuery.map(({
    id,
    list_id: listId,
    namespace_type: namespaceType
  }) => ({
    id,
    listId,
    namespaceType
  })), [exceptionListsToQuery]);
  const isEndpointSpecified = (0, _react.useMemo)(() => listTypes.length === 1 && listTypes[0] === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT, [listTypes]);
  const canWriteEndpointExceptions = (0, _use_endpoint_exceptions_capability.useEndpointExceptionsCapability)('crudEndpointExceptions');

  // Reducer state
  const [{
    exceptions,
    pagination,
    currenFlyout,
    exceptionToEdit,
    viewerState,
    isReadOnly,
    lastUpdated,
    exceptionsToShow
  }, dispatch] = (0, _react.useReducer)((0, _reducer.allExceptionItemsReducer)(), {
    ...initialState
  });
  const isReadOnlyOnCurrentList = isEndpointSpecified ? !canWriteEndpointExceptions : isReadOnly;

  // Reducer actions
  const setLastUpdated = (0, _react.useCallback)(lastUpdate => {
    dispatch({
      type: 'setLastUpdateTime',
      lastUpdate
    });
  }, [dispatch]);
  const setExceptions = (0, _react.useCallback)(({
    exceptions: newExceptions,
    pagination: newPagination
  }) => {
    setLastUpdated(Date.now());
    dispatch({
      type: 'setExceptions',
      exceptions: newExceptions,
      pagination: newPagination
    });
  }, [dispatch, setLastUpdated]);
  const setViewerState = (0, _react.useCallback)(state => {
    dispatch({
      type: 'setViewerState',
      state
    });
  }, [dispatch]);
  const setFlyoutType = (0, _react.useCallback)(flyoutType => {
    dispatch({
      type: 'updateFlyoutOpen',
      flyoutType
    });
  }, [dispatch]);
  const setReadOnly = (0, _react.useCallback)(readOnly => {
    dispatch({
      type: 'setIsReadOnly',
      readOnly
    });
  }, [dispatch]);
  const setExceptionsToShow = (0, _react.useCallback)(optionId => {
    dispatch({
      type: 'setExceptionsToShow',
      optionId
    });
  }, [dispatch]);
  const [isLoadingReferences, isFetchReferencesError, allReferences, fetchReferences] = (0, _use_find_references.useFindExceptionListReferences)();
  (0, _react.useEffect)(() => {
    if (fetchReferences != null && exceptionListsFormattedForReferenceQuery.length) {
      fetchReferences(exceptionListsFormattedForReferenceQuery);
    }
  }, [exceptionListsFormattedForReferenceQuery, fetchReferences]);
  (0, _react.useEffect)(() => {
    if (isFetchReferencesError) {
      setViewerState('error');
    } else if (viewerState == null && isLoadingReferences) {
      setViewerState('loading');
    } else if (viewerState === 'loading' && !isLoadingReferences) {
      setViewerState(null);
    }
  }, [isLoadingReferences, isFetchReferencesError, setViewerState, viewerState]);
  const namespaceTypes = (0, _react.useMemo)(() => exceptionListsToQuery.map(list => list.namespace_type), [exceptionListsToQuery]);
  const exceptionListFilter = (0, _react.useMemo)(() => {
    if (isEndpointSpecified || exceptionsToShow.active && exceptionsToShow.expired) {
      return undefined;
    }
    const savedObjectPrefixes = (0, _securitysolutionListUtils.getSavedObjectTypes)({
      namespaceType: namespaceTypes
    });
    if (exceptionsToShow.active) {
      return (0, _securitysolutionListUtils.buildShowActiveExceptionsFilter)(savedObjectPrefixes);
    }
    if (exceptionsToShow.expired) {
      return (0, _securitysolutionListUtils.buildShowExpiredExceptionsFilter)(savedObjectPrefixes);
    }
  }, [exceptionsToShow, namespaceTypes, isEndpointSpecified]);
  const handleFetchItems = (0, _react.useCallback)(async options => {
    var _options$pagination$p;
    const abortCtrl = new AbortController();
    const newPagination = (options === null || options === void 0 ? void 0 : options.pagination) != null ? {
      page: ((_options$pagination$p = options.pagination.page) !== null && _options$pagination$p !== void 0 ? _options$pagination$p : 0) + 1,
      perPage: options.pagination.perPage
    } : {
      page: pagination.pageIndex + 1,
      perPage: pagination.pageSize
    };
    if (exceptionListsToQuery.length === 0) {
      return {
        data: [],
        pageIndex: pagination.pageIndex,
        itemsPerPage: pagination.pageSize,
        total: 0
      };
    }
    const {
      page: pageIndex,
      per_page: itemsPerPage,
      total,
      data
    } = await (0, _securitysolutionListApi.fetchExceptionListsItemsByListIds)({
      filter: exceptionListFilter,
      http: services.http,
      listIds: exceptionListsToQuery.map(list => list.list_id),
      namespaceTypes,
      search: options === null || options === void 0 ? void 0 : options.search,
      pagination: newPagination,
      signal: abortCtrl.signal
    });

    // Please see `kbn-securitysolution-list-hooks/src/transforms/index.test.ts` doc notes
    // for context around the temporary `id`
    const transformedData = data.map(item => (0, _securitysolutionListHooks.transformInput)(item));
    return {
      data: transformedData,
      pageIndex,
      itemsPerPage,
      total
    };
  }, [pagination.pageIndex, pagination.pageSize, exceptionListsToQuery, services.http, exceptionListFilter, namespaceTypes]);
  const getTotalExceptionCount = (0, _react.useCallback)(async () => {
    const abortCtrl = new AbortController();
    if (exceptionListsToQuery.length === 0) {
      return 0;
    }
    const {
      total
    } = await (0, _securitysolutionListApi.fetchExceptionListsItemsByListIds)({
      filter: undefined,
      http: services.http,
      listIds: exceptionListsToQuery.map(list => list.list_id),
      namespaceTypes,
      pagination: {},
      signal: abortCtrl.signal
    });
    return total;
  }, [exceptionListsToQuery, namespaceTypes, services.http]);
  const handleGetExceptionListItems = (0, _react.useCallback)(async options => {
    try {
      const {
        pageIndex,
        itemsPerPage,
        total,
        data
      } = await handleFetchItems(options);
      setViewerState(total > 0 ? null : 'empty');
      setExceptions({
        exceptions: data,
        pagination: {
          page: pageIndex,
          perPage: itemsPerPage,
          total
        }
      });
      setViewerState(total > 0 ? null : (await getTotalExceptionCount()) > 0 ? 'empty_search' : 'empty');
    } catch (e) {
      setViewerState('error');
      toasts.addError(e, {
        title: i18n.EXCEPTION_ERROR_TITLE,
        toastMessage: i18n.EXCEPTION_ERROR_DESCRIPTION
      });
    }
  }, [handleFetchItems, setExceptions, setViewerState, toasts, getTotalExceptionCount]);
  const handleSearch = (0, _react.useCallback)(async options => {
    try {
      setViewerState('searching');
      const {
        pageIndex,
        itemsPerPage,
        total,
        data
      } = await handleFetchItems(options);
      setViewerState(total > 0 ? null : 'empty_search');
      setExceptions({
        exceptions: data,
        pagination: {
          page: pageIndex,
          perPage: itemsPerPage,
          total
        }
      });
    } catch (e) {
      toasts.addError(e, {
        title: i18n.EXCEPTION_SEARCH_ERROR_TITLE,
        toastMessage: i18n.EXCEPTION_SEARCH_ERROR_BODY
      });
    }
  }, [handleFetchItems, setExceptions, setViewerState, toasts]);
  const handleExceptionsToShow = (0, _react.useCallback)(optionId => {
    setExceptionsToShow(optionId);
  }, [setExceptionsToShow]);
  const handleAddException = (0, _react.useCallback)(() => {
    setFlyoutType('addException');
  }, [setFlyoutType]);
  const handleEditException = (0, _react.useCallback)(exception => {
    dispatch({
      type: 'updateExceptionToEdit',
      exception
    });
    setFlyoutType('editException');
  }, [setFlyoutType]);
  const handleCancelExceptionItemFlyout = (0, _react.useCallback)(didRuleChange => {
    setFlyoutType(null);
    if (didRuleChange && onRuleChange != null) {
      onRuleChange();
    }
  }, [onRuleChange, setFlyoutType]);
  const handleConfirmExceptionFlyout = (0, _react.useCallback)(didRuleChange => {
    setFlyoutType(null);
    if (didRuleChange && onRuleChange != null) {
      onRuleChange();
    }
    handleGetExceptionListItems();
  }, [setFlyoutType, handleGetExceptionListItems, onRuleChange]);
  const handleDeleteException = (0, _react.useCallback)(async ({
    id: itemId,
    name,
    namespaceType
  }) => {
    const abortCtrl = new AbortController();
    try {
      setViewerState('deleting');
      await (0, _securitysolutionListApi.deleteExceptionListItemById)({
        http: services.http,
        id: itemId,
        namespaceType,
        signal: abortCtrl.signal
      });
      toasts.addSuccess({
        title: i18n.EXCEPTION_ITEM_DELETE_TITLE,
        text: i18n.EXCEPTION_ITEM_DELETE_TEXT(name)
      });
      await handleGetExceptionListItems();
    } catch (e) {
      setViewerState('error');
      toasts.addError(e, {
        title: i18n.EXCEPTION_DELETE_ERROR_TITLE
      });
    }
  }, [handleGetExceptionListItems, services.http, setViewerState, toasts]);

  // User privileges checks
  (0, _react.useEffect)(() => {
    setReadOnly(isViewReadOnly || !canUserCRUD || !hasIndexWrite);
  }, [setReadOnly, isViewReadOnly, canUserCRUD, hasIndexWrite]);
  (0, _react.useEffect)(() => {
    if (exceptionListsToQuery.length > 0) {
      handleGetExceptionListItems();
    } else {
      setViewerState('empty');
    }
  }, [exceptionListsToQuery.length, handleGetExceptionListItems, setViewerState]);
  const exceptionToEditList = (0, _react.useMemo)(() => allReferences != null && exceptionToEdit != null ? allReferences[exceptionToEdit.list_id] : null, [allReferences, exceptionToEdit]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currenFlyout === 'editException' && exceptionToEditList != null && exceptionToEdit != null && rule != null && /*#__PURE__*/_react.default.createElement(_edit_exception_flyout.EditExceptionFlyout, {
    rule: rule,
    list: exceptionToEditList,
    itemToEdit: exceptionToEdit,
    showAlertCloseOptions: true,
    onCancel: handleCancelExceptionItemFlyout,
    onConfirm: handleConfirmExceptionFlyout,
    "data-test-subj": "editExceptionItemFlyout"
  }), currenFlyout === 'addException' && rule != null && /*#__PURE__*/_react.default.createElement(_add_exception_flyout.AddExceptionFlyout, {
    rules: [rule],
    isBulkAction: false,
    isEndpointItem: isEndpointSpecified,
    onCancel: handleCancelExceptionItemFlyout,
    onConfirm: handleConfirmExceptionFlyout,
    "data-test-subj": "addExceptionItemFlyout",
    showAlertCloseOptions: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledText, {
    size: "s"
  }, isEndpointSpecified ? i18n.ENDPOINT_EXCEPTIONS_TAB_ABOUT : i18n.EXCEPTIONS_TAB_ABOUT), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), !STATES_FILTERS_HIDDEN.includes(viewerState) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utility_bar.ExceptionsViewerUtility, {
    pagination: pagination,
    exceptionsToShow: exceptionsToShow,
    onChangeExceptionsToShow: handleExceptionsToShow,
    lastUpdated: lastUpdated,
    isEndpoint: isEndpointSpecified
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_search_bar.ExceptionsViewerSearchBar, {
    isReadOnly: isReadOnlyOnCurrentList,
    isEndpoint: isEndpointSpecified,
    isSearching: viewerState === 'searching',
    onSearch: handleSearch,
    onAddExceptionClick: handleAddException
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_all_items.ExceptionsViewerItems, {
    isReadOnly: isReadOnlyOnCurrentList,
    disableActions: isReadOnlyOnCurrentList || viewerState === 'deleting',
    exceptions: exceptions,
    isEndpoint: isEndpointSpecified,
    ruleReferences: allReferences,
    viewerState: viewerState,
    onDeleteException: handleDeleteException,
    onEditExceptionItem: handleEditException,
    onCreateExceptionListItem: handleAddException
  }), !STATES_PAGINATION_UTILITY_HIDDEN.includes(viewerState) && /*#__PURE__*/_react.default.createElement(_pagination.ExceptionsViewerPagination, {
    onPaginationChange: handleGetExceptionListItems,
    pagination: pagination
  }))));
};
ExceptionsViewerComponent.displayName = 'ExceptionsViewerComponent';
const ExceptionsViewer = exports.ExceptionsViewer = /*#__PURE__*/_react.default.memo(ExceptionsViewerComponent);
ExceptionsViewer.displayName = 'ExceptionsViewer';