"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _optional_field_label = require("../../../rule_creation/components/optional_field_label");
var _validators = require("../../../../common/utils/validators");
var _default_risk_score_validator = require("../../validators/default_risk_score_validator");
var _max_signals_validator_factory = require("../../validators/max_signals_validator_factory");
var I18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const schema = exports.schema = {
  author: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: I18n.AUTHOR_FIELD_LABEL,
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldAuthorHelpText', {
      defaultMessage: 'Type one or more authors for this rule. Press enter after each author to add a new one.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.authorFieldEmptyError', {
        defaultMessage: 'An author must not be empty'
      })),
      type: _shared_imports.VALIDATION_TYPES.ARRAY_ITEM,
      isBlocking: false
    }]
  },
  name: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldNameLabel', {
      defaultMessage: 'Name'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.nameFieldRequiredError', {
        defaultMessage: 'A name is required.'
      }))
    }]
  },
  description: {
    type: _shared_imports.FIELD_TYPES.TEXTAREA,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldDescriptionLabel', {
      defaultMessage: 'Description'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.descriptionFieldRequiredError', {
        defaultMessage: 'A description is required.'
      }))
    }]
  },
  isBuildingBlock: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldBuildingBlockLabel', {
      defaultMessage: 'Mark all generated alerts as "building block" alerts'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  maxSignals: {
    type: _shared_imports.FIELD_TYPES.NUMBER,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.fieldMaxAlertsLabel', {
      defaultMessage: 'Max alerts per run'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: (0, _max_signals_validator_factory.maxSignalsValidatorFactory)()
    }]
  },
  isAssociatedToEndpointList: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldAssociatedToEndpointListLabel', {
      defaultMessage: 'Add existing Endpoint exceptions to the rule'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  severity: {
    value: {},
    mapping: {},
    isMappingChecked: {}
  },
  riskScore: {
    value: {},
    mapping: {},
    isMappingChecked: {},
    validations: [{
      validator: (...args) => {
        const [{
          value: fieldValue,
          path
        }] = args;
        const defaultRiskScore = fieldValue.value;
        return (0, _default_risk_score_validator.defaultRiskScoreValidator)(defaultRiskScore, path);
      }
    }]
  },
  references: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldReferenceUrlsLabel', {
      defaultMessage: 'Reference URLs'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: (...args) => {
        const [{
          value,
          path
        }] = args;
        let hasError = false;
        value.forEach(url => {
          if ((0, _validators.isUrlInvalid)(url)) {
            hasError = true;
          }
        });
        return hasError ? {
          code: 'ERR_FIELD_FORMAT',
          path,
          message: I18n.URL_FORMAT_INVALID
        } : undefined;
      }
    }]
  },
  falsePositives: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldFalsePositiveLabel', {
      defaultMessage: 'False positive examples'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  investigationFields: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldCustomHighlightedFieldsLabel', {
      defaultMessage: 'Custom highlighted fields'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  license: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: I18n.LICENSE_FIELD_LABEL,
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldLicenseHelpText', {
      defaultMessage: 'Add a license name'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  ruleNameOverride: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRuleNameOverrideLabel', {
      defaultMessage: 'Rule name override'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRuleNameOverrideHelpText', {
      defaultMessage: 'Choose a field from the source event to populate the rule name in the alert list.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  threat: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldMitreThreatLabel', {
      defaultMessage: 'MITRE ATT&CK\u2122'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  threatIndicatorPath: {},
  timestampOverride: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimestampOverrideLabel', {
      defaultMessage: 'Timestamp override'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimestampOverrideHelpText', {
      defaultMessage: 'Choose timestamp field used when executing rule. Pick field with timestamp closest to ingest time (e.g. event.ingested).'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  timestampOverrideFallbackDisabled: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    defaultValue: false,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimestampOverrideFallbackDisabledLabel', {
      defaultMessage: 'Do not use @timestamp as a fallback timestamp field'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  tags: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTagsLabel', {
      defaultMessage: 'Tags'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTagsHelpText', {
      defaultMessage: 'Type one or more custom identifying tags for this rule. Press enter after each tag to begin a new one.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.tagFieldEmptyError', {
        defaultMessage: 'A tag must not be empty'
      })),
      type: _shared_imports.VALIDATION_TYPES.ARRAY_ITEM,
      isBlocking: false
    }]
  },
  note: {
    type: _shared_imports.FIELD_TYPES.TEXTAREA,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.guideLabel', {
      defaultMessage: 'Investigation guide'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.guideHelpText', {
      defaultMessage: 'Provide helpful information for analysts that are investigating detection alerts. This guide will appear on the rule details page and in timelines (as notes) created from detection alerts generated by this rule.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  setup: {
    type: _shared_imports.FIELD_TYPES.TEXTAREA,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.setupLabel', {
      defaultMessage: 'Setup guide'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.setupHelpText', {
      defaultMessage: 'Provide instructions on rule prerequisites such as required integrations, configuration steps, and anything else needed for the rule to work correctly.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  }
};