"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlCardDescription = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireDefault(require("react"));
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SmallText = _styledComponents.default.span`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
`;
const MlCardDescriptionComponent = ({
  hasValidLicense = false
}) => /*#__PURE__*/_react.default.createElement(SmallText, null, hasValidLicense ? _translations.ML_TYPE_DESCRIPTION : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.mlTypeDisabledDescription",
  defaultMessage: "Access to ML requires a {subscriptionsLink}.",
  values: {
    subscriptionsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/subscriptions",
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.components.stepDefineRule.ruleTypeField.subscriptionsLink",
      defaultMessage: "Platinum subscription"
    }))
  }
}));
MlCardDescriptionComponent.displayName = 'MlCardDescriptionComponent';
const MlCardDescription = exports.MlCardDescription = /*#__PURE__*/_react.default.memo(MlCardDescriptionComponent);
MlCardDescription.displayName = 'MlCardDescription';