"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildESQLWithKQLQuery = void 0;
exports.esqlResponseToRecords = esqlResponseToRecords;
var _esqlAst = require("@kbn/esql-ast");
var _fp = require("lodash/fp");
var _kql = require("../../../common/utils/kql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This function is used to add a KQL query to an ESQL query.
 */
const buildESQLWithKQLQuery = (esql, kqlQuery) => {
  const {
    errors,
    root
  } = (0, _esqlAst.parse)(esql);
  if (errors.length > 0) {
    return esql;
  }
  if ((0, _fp.isString)(kqlQuery) && kqlQuery !== '') {
    const kqlWhere = _esqlAst.synth.cmd`WHERE KQL("${(0, _kql.escapeKQLStringParam)(kqlQuery)}")`;
    const index = root.commands.findIndex(cmd => cmd.name === 'from');
    _esqlAst.mutate.generic.commands.insert(root, kqlWhere, index + 1); // add 'where'command after the 'from' command
    return _esqlAst.BasicPrettyPrinter.print(root);
  }
  return esql;
};

// Function copied from elasticsearch-8.x/lib/helpers
exports.buildESQLWithKQLQuery = buildESQLWithKQLQuery;
function esqlResponseToRecords(response) {
  if (!response) return [];
  const {
    columns,
    values
  } = response;
  return values.map(row => {
    const doc = {};
    row.forEach((cell, index) => {
      const {
        name
      } = columns[index];
      doc[name] = cell;
    });
    return doc;
  });
}