"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderPage = exports.HeaderLinkBack = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _link_icon = require("../link_icon");
var _subtitle = require("../subtitle");
var _title = require("./title");
var _link_to = require("../link_to");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Divider() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        border-bottom: ${euiTheme.border.thin};
      `
  });
}
const useHeaderLinkBackStyles = () => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const fontSizeXs = (0, _eui.euiFontSize)(euiThemeContext, 'xs').fontSize;
  const lineHeightS = (0, _eui.euiFontSize)(euiThemeContext, 's').lineHeight;
  const {
    euiTheme
  } = euiThemeContext;
  return {
    linkBack: (0, _react2.css)`
      font-size: ${fontSizeXs};
      line-height: ${lineHeightS};
      margin-bottom: ${euiTheme.size.s};
    `
  };
};
const HeaderLinkBack = exports.HeaderLinkBack = /*#__PURE__*/_react.default.memo(({
  backOptions
}) => {
  var _backOptions$path, _backOptions$dataTest;
  const styles = useHeaderLinkBackStyles();
  const {
    navigateToUrl
  } = (0, _kibana.useKibana)().services.application;
  const {
    formatUrl
  } = (0, _link_to.useFormatUrl)(backOptions.pageId);
  const backUrl = formatUrl((_backOptions$path = backOptions.path) !== null && _backOptions$path !== void 0 ? _backOptions$path : '');
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.linkBack,
    className: "securitySolutionHeaderPage__linkBack"
  }, /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
    dataTestSubj: (_backOptions$dataTest = backOptions.dataTestSubj) !== null && _backOptions$dataTest !== void 0 ? _backOptions$dataTest : 'link-back',
    onClick: ev => {
      ev.preventDefault();
      navigateToUrl(backUrl);
    },
    href: backUrl,
    iconType: "arrowLeft"
  }, backOptions.text));
});
HeaderLinkBack.displayName = 'HeaderLinkBack';
const headerPageStyles = {
  // Without  min-width: 0, as a flex child, it wouldn't shrink properly
  // and could overflow its parent.
  headerSection: (0, _react2.css)`
    min-width: 0;
    max-width: 100%;
  `
};
const HeaderPageComponent = ({
  backOptions,
  backComponent,
  badgeOptions,
  border,
  children,
  isLoading,
  rightSideItems,
  subtitle,
  subtitle2,
  title,
  titleNode
}) => /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "header-page"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
  alignItems: "center",
  rightSideItems: rightSideItems
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
  css: headerPageStyles.headerSection
}, backOptions && /*#__PURE__*/_react.default.createElement(HeaderLinkBack, {
  backOptions: backOptions
}), !backOptions && backComponent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, backComponent), titleNode || /*#__PURE__*/_react.default.createElement(_title.Title, {
  title: title,
  badgeOptions: badgeOptions
}), subtitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_subtitle.Subtitle, {
  "data-test-subj": "header-page-subtitle",
  items: subtitle
})), border && isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
  size: "xs",
  color: "accent"
})), children && /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
  "data-test-subj": "header-page-supplements"
}, children)), subtitle2 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_subtitle.Subtitle, {
  "data-test-subj": "header-page-subtitle-2",
  items: subtitle2
})), border && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(Divider, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}));
const HeaderPage = exports.HeaderPage = /*#__PURE__*/_react.default.memo(HeaderPageComponent);