"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureSetupInfoContent = exports.AzureInputVarFields = exports.AzureCredentialsForm = exports.ARM_TEMPLATE_EXTERNAL_DOC_URL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/fleet-plugin/public");
var _azure_credentials_form_options = require("./azure_credentials_form_options");
var _hooks = require("./hooks");
var _utils = require("../utils");
var _asset_boxed_radio_group = require("../asset_boxed_radio_group");
var _test_subjects = require("../test_subjects");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AzureSetupInfoContent = ({
  documentationLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.setupInfoContentTitle",
    defaultMessage: "Setup Access"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.gettingStarted.setupInfoContent",
    defaultMessage: "Utilize an Azure Resource Manager (ARM) template (a built-in Azure IaC tool) or a series of manual steps to set up and deploy Cloud Asset Discovery for assessing your Azure environment's assets. Refer to our {gettingStartedLink} guide for details.",
    values: {
      gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: documentationLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.gettingStarted.setupInfoContentLink",
        defaultMessage: "Getting Started"
      }))
    }
  })));
};
exports.AzureSetupInfoContent = AzureSetupInfoContent;
const getSetupFormatOptions = () => [{
  id: _constants.AZURE_SETUP_FORMAT.ARM_TEMPLATE,
  label: 'ARM Template',
  testId: _test_subjects.CAI_AZURE_SETUP_FORMAT_TEST_SUBJECTS.ARM_TEMPLATE
}, {
  id: _constants.AZURE_SETUP_FORMAT.MANUAL,
  label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.setupFormatOptions.manual', {
    defaultMessage: 'Manual'
  }),
  testId: _test_subjects.CAI_AZURE_SETUP_FORMAT_TEST_SUBJECTS.MANUAL
}];
const ARM_TEMPLATE_EXTERNAL_DOC_URL = exports.ARM_TEMPLATE_EXTERNAL_DOC_URL = 'https://learn.microsoft.com/en-us/azure/azure-resource-manager/templates/';
const ArmTemplateSetup = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ol", {
    css: (0, _react2.css)`
            list-style: auto;
          `
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.armTemplateSetupStep.hostRequirement",
    defaultMessage: "Ensure \"New hosts\" is selected in the \"Where to add this integration?\" section below"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.armTemplateSetupStep.login",
    defaultMessage: "Log in to your Azure portal."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.armTemplateSetupStep.save",
    defaultMessage: "Click the Save and continue button on the bottom right of this page."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.armTemplateSetupStep.launch",
    defaultMessage: "On the subsequent pop-up modal, copy the relevant Bash command, then click on the Launch ARM Template button."
  })))));
};
const AzureCredentialTypeSelector = ({
  type,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  fullWidth: true,
  label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.azureCredentialTypeSelectorLabel', {
    defaultMessage: 'Preferred manual method'
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  fullWidth: true,
  options: (0, _azure_credentials_form_options.getAzureCredentialsFormManualOptions)(),
  value: type,
  onChange: optionElem => {
    onChange(optionElem.target.value);
  },
  "data-test-subj": _test_subjects.AZURE_CREDENTIALS_TYPE_SELECTOR_TEST_SUBJ
}));
const AzureInputVarFields = ({
  fields,
  packageInfo,
  onChange,
  hasInvalidRequiredVars
}) => {
  return /*#__PURE__*/_react.default.createElement("div", null, fields.map((field, index) => {
    const invalid = (0, _utils.fieldIsInvalid)(field.value, hasInvalidRequiredVars);
    const invalidError = _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.googleCloudShellCredentials.integration.fieldRequired', {
      defaultMessage: '{field} is required',
      values: {
        field: field.label
      }
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      key: index
    }, field.type === 'password' && field.isSecret === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
                    width: 100%;
                    .euiFormControlLayout,
                    .euiFormControlLayout__childrenWrapper,
                    .euiFormRow,
                    input {
                      max-width: 100%;
                      width: 100%;
                    }
                  `
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l"
      })
    }, /*#__PURE__*/_react.default.createElement(_public.LazyPackagePolicyInputVarField, {
      varDef: {
        ...((0, _utils.findVariableDef)(packageInfo, field.id) || {}),
        name: field.id,
        // Ensure 'name' is explicitly set
        required: true,
        type: 'password'
      },
      value: field.value || '',
      onChange: value => {
        onChange(field.id, value);
      },
      errors: invalid ? [invalidError] : [],
      forceShowErrors: invalid,
      isEditPage: true
    })))), field.type === 'text' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: field.id,
      label: field.label,
      fullWidth: true,
      hasChildLabel: true,
      id: field.id,
      isInvalid: invalid,
      error: invalid ? invalidError : undefined
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      id: field.id,
      fullWidth: true,
      value: field.value || '',
      onChange: event => onChange(field.id, event.target.value),
      "data-test-subj": field.testSubj,
      isInvalid: invalid
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })));
  }));
};
exports.AzureInputVarFields = AzureInputVarFields;
const AzureCredentialsForm = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  disabled,
  hasInvalidRequiredVars
}) => {
  const {
    group,
    fields,
    azureCredentialsType,
    setupFormat,
    onSetupFormatChange,
    documentationLink
  } = (0, _hooks.useAzureCredentialsForm)({
    newPolicy,
    input,
    packageInfo,
    updatePolicy
  });
  (0, _react.useEffect)(() => {
    if (!setupFormat) {
      onSetupFormatChange(_constants.AZURE_SETUP_FORMAT.ARM_TEMPLATE);
    }
  }, [setupFormat, onSetupFormatChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AzureSetupInfoContent, {
    documentationLink: documentationLink
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_asset_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    size: "m",
    options: getSetupFormatOptions(),
    idSelected: setupFormat,
    onChange: idSelected => idSelected !== setupFormat && onSetupFormatChange(idSelected),
    name: "setupFormat"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), setupFormat === _constants.AZURE_SETUP_FORMAT.ARM_TEMPLATE && /*#__PURE__*/_react.default.createElement(ArmTemplateSetup, null), setupFormat === _constants.AZURE_SETUP_FORMAT.MANUAL && /*#__PURE__*/_react.default.createElement(AzureCredentialTypeSelector, {
    type: azureCredentialsType,
    onChange: optionId => {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'azure.credentials.type': {
          value: optionId
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(AzureInputVarFields, {
    fields: fields,
    packageInfo: packageInfo,
    onChange: (key, value) => {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      }));
    },
    hasInvalidRequiredVars: hasInvalidRequiredVars
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), group.info, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.manualCredentialType.documentation",
    defaultMessage: "Read the {documentation} for more details",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: ARM_TEMPLATE_EXTERNAL_DOC_URL,
        target: "_blank",
        rel: "noopener nofollow noreferrer",
        "data-test-subj": "externalLink"
      }, _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.documentationLinkText', {
        defaultMessage: 'documentation'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.AzureCredentialsForm = AzureCredentialsForm;