"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputVarsFields = exports.getAwsCredentialsFormOptions = exports.getAwsCredentialsFormManualOptions = exports.getAwsCredentialsFormAgentlessOptions = exports.getAwsCloudConnectorsFormAgentlessOptions = exports.getAwsCloudConnectorsCredentialsFormOptions = exports.getAwsAgentlessFormOptions = exports.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AGENTLESS_CLOUD_CONNECTORS_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssumeRoleDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.assetInventory.fleetIntegration.assumeRoleDescription",
  defaultMessage: "An IAM role Amazon Resource Name (ARN) is an IAM identity that you can create in your AWS account. When creating an IAM role, users can define the role\u2019s permissions. Roles do not have standard long-term credentials such as passwords or access keys."
})));
const DirectAccessKeysDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.assetInventory.fleetIntegration.directAccessKeysDescription",
  defaultMessage: "Access keys are long-term credentials for an IAM user or the AWS account root user."
})));
const TemporaryKeysDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.assetInventory.fleetIntegration.temporaryKeysDescription",
  defaultMessage: "You can configure temporary security credentials in AWS to last for a specified duration. They consist of an access key ID, a secret access key, and a security token, which is typically found using GetSessionToken."
})));
const SharedCredentialsDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.assetInventory.fleetIntegration.sharedCredentialsDescription",
  defaultMessage: "If you use different AWS credentials for different tools or applications, you can use profiles to define multiple access keys in the same configuration file."
})));
const AWS_FIELD_LABEL = {
  access_key_id: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.accessKeyIdLabel', {
    defaultMessage: 'Access Key ID'
  }),
  secret_access_key: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.secretAccessKeyLabel', {
    defaultMessage: 'Secret Access Key'
  })
};
const getInputVarsFields = (input, fields) => Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
  const field = fields[id];
  return {
    id,
    label: field.label,
    type: field.type || 'text',
    value: inputVar.value,
    dataTestSubj: field.dataTestSubj,
    isSecret: field.isSecret
  };
});
exports.getInputVarsFields = getInputVarsFields;
const getAwsCredentialsTypeSelectorOptions = (filterFn, getFormOptions = getAwsCredentialsFormOptions) => {
  return Object.entries(getFormOptions()).map(([key, value]) => ({
    value: key,
    text: value.label
  })).filter(filterFn);
};
const getAwsCredentialsFormManualOptions = () => getAwsCredentialsTypeSelectorOptions(({
  value
}) => value !== _constants.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION);
exports.getAwsCredentialsFormManualOptions = getAwsCredentialsFormManualOptions;
const getAwsCredentialsFormAgentlessOptions = () => getAwsCredentialsTypeSelectorOptions(({
  value
}) => value === _constants.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS || value === _constants.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS);
exports.getAwsCredentialsFormAgentlessOptions = getAwsCredentialsFormAgentlessOptions;
const getAwsCloudConnectorsFormAgentlessOptions = () => getAwsCredentialsTypeSelectorOptions(({
  value
}) => value === _constants.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS || value === _constants.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS || value === _constants.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS, getAwsCloudConnectorsCredentialsFormOptions);
exports.getAwsCloudConnectorsFormAgentlessOptions = getAwsCloudConnectorsFormAgentlessOptions;
const DEFAULT_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AWS_CREDENTIALS_TYPE = _constants.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION;
const DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE = exports.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE = _constants.AWS_CREDENTIALS_TYPE.ASSUME_ROLE;
const DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE = _constants.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS;
const DEFAULT_AGENTLESS_CLOUD_CONNECTORS_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AGENTLESS_CLOUD_CONNECTORS_AWS_CREDENTIALS_TYPE = _constants.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS;
const getAwsCredentialsFormOptions = () => ({
  [_constants.AWS_CREDENTIALS_TYPE.ASSUME_ROLE]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration..assumeRoleLabel', {
      defaultMessage: 'Assume role'
    }),
    info: AssumeRoleDescription,
    fields: {
      'aws.role_arn': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.roleArnLabel', {
          defaultMessage: 'Role ARN'
        }),
        dataTestSubj: 'awsRoleArnInput'
      }
    }
  },
  [_constants.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration..directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      'aws.access_key_id': {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsDirectAccessKeyId'
      },
      'aws.secret_access_key': {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsDirectAccessSecretKey',
        isSecret: true
      }
    }
  },
  [_constants.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS]: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      'aws.access_key_id': {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsTemporaryKeysAccessKeyId'
      },
      'aws.secret_access_key': {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsTemporaryKeysSecretAccessKey',
        isSecret: true
      },
      'aws.session_token': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.sessionTokenLabel', {
          defaultMessage: 'Session Token'
        }),
        dataTestSubj: 'awsTemporaryKeysSessionToken'
      }
    }
  },
  [_constants.AWS_CREDENTIALS_TYPE.SHARED_CREDENTIALS]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.sharedCredentialLabel', {
      defaultMessage: 'Shared credentials'
    }),
    info: SharedCredentialsDescription,
    fields: {
      'aws.shared_credential_file': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.sharedCredentialFileLabel', {
          defaultMessage: 'Shared Credential File'
        }),
        dataTestSubj: 'awsSharedCredentialFile'
      },
      'aws.credential_profile_name': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.credentialProfileNameLabel', {
          defaultMessage: 'Credential Profile Name'
        }),
        dataTestSubj: 'awsCredentialProfileName'
      }
    }
  },
  [_constants.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION]: {
    label: 'CloudFormation',
    info: [],
    fields: {}
  }
});
exports.getAwsCredentialsFormOptions = getAwsCredentialsFormOptions;
const getAwsCloudConnectorsCredentialsFormOptions = () => ({
  [_constants.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.cloudConnectorsRoleLabel', {
      defaultMessage: 'Cloud Connectors (recommended)'
    }),
    info: AssumeRoleDescription,
    fields: {
      'aws.role_arn': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration..roleArnLabel', {
          defaultMessage: 'Role ARN'
        }),
        type: 'text',
        dataTestSubj: 'awsRoleArnInput'
      },
      'aws.credentials.external_id': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.externalId', {
          defaultMessage: 'External ID'
        }),
        type: 'password',
        dataTestSubj: 'awsExternalId',
        isSecret: true
      }
    }
  },
  [_constants.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      'aws.access_key_id': {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsDirectAccessKeyId'
      },
      'aws.secret_access_key': {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsDirectAccessSecretKey',
        isSecret: true
      }
    }
  },
  [_constants.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS]: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      'aws.access_key_id': {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsTemporaryKeysAccessKeyId'
      },
      'aws.secret_access_key': {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsTemporaryKeysSecretAccessKey',
        isSecret: true
      },
      'aws.session_token': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration..sessionTokenLabel', {
          defaultMessage: 'Session Token'
        }),
        dataTestSubj: 'awsTemporaryKeysSessionToken'
      }
    }
  }
});
exports.getAwsCloudConnectorsCredentialsFormOptions = getAwsCloudConnectorsCredentialsFormOptions;
const getAwsAgentlessFormOptions = () => ({
  [_constants.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegrationƒ.directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      'aws.access_key_id': {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsDirectAccessKeyId'
      },
      'aws.secret_access_key': {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsDirectAccessSecretKey',
        isSecret: true
      }
    }
  },
  [_constants.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS]: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      'aws.access_key_id': {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsTemporaryKeysAccessKeyId'
      },
      'aws.secret_access_key': {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsTemporaryKeysSecretAccessKey',
        isSecret: true
      },
      'aws.session_token': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.sessionTokenLabel', {
          defaultMessage: 'Session Token'
        }),
        dataTestSubj: 'awsTemporaryKeysSessionToken'
      }
    }
  }
});
exports.getAwsAgentlessFormOptions = getAwsAgentlessFormOptions;