"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndpointPackageInfo = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _usage_tracker = require("../data_loaders/usage_tracker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEndpointPackageInfo = exports.getEndpointPackageInfo = _usage_tracker.usageTracker.track('getEndpointPackageInfo', async kbnClient => {
  const path = _common.epmRouteService.getInfoPath('endpoint');
  const endpointPackage = (await kbnClient.request({
    path,
    headers: {
      'Elastic-Api-Version': _common.API_VERSIONS.public.v1
    },
    method: 'GET'
  })).data.item;
  if (!endpointPackage) {
    throw new Error('EPM Endpoint package was not found!');
  }
  return endpointPackage;
});