"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActivityLogItemTypes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** The output provided by some of the Endpoint responses */

const ActivityLogItemTypes = exports.ActivityLogItemTypes = {
  ACTION: 'action',
  RESPONSE: 'response',
  FLEET_ACTION: 'fleetAction',
  FLEET_RESPONSE: 'fleetResponse'
};

/**
 * An endpoint Action created in the Endpoint's `.logs-endpoint.actions-default` index.
 * @since v7.16
 */

/**
 * An Action response written by the endpoint to the Endpoint `.logs-endpoint.action.responses` datastream
 * @since v7.16
 */

/** Output content of the different response actions */

/**
 * The data stored with each Response Action under `EndpointActions.data` property
 */

/**
 * And endpoint action created in Fleet's `.fleet-actions`
 */

/**
 * The action response created in Fleet's index after the action has been successfully delivered to
 * the endpoint
 */

/**
 * One of the possible Response Action Log entry - Either a Fleet Action request, Fleet action response,
 * Endpoint action request and/or endpoint action response.
 */

/** Note: this type should almost never be used. Use instead the response action specific types above */

/** Action Details normally returned by Action List API response  */

/**
 * File upload metadata information. Stored by endpoint/fleet-server when a file is uploaded to ES in connection with
 * a response action
 */

/**
 * The parameters that are sent to the Endpoint.
 *
 * NOTE: Most of the parameters below are NOT accepted via the API. They are inserted into
 * the action's parameters via the API route handler
 */