"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformStatsMetadata = exports.StoreStatusEnum = exports.StoreStatus = exports.Metadata = exports.Interval = exports.InspectQuery = exports.IndexPattern = exports.EntityTypeEnum = exports.EntityType = exports.EngineStatusEnum = exports.EngineStatus = exports.EngineDescriptor = exports.EngineComponentStatus = exports.EngineComponentResourceEnum = exports.EngineComponentResource = exports.BaseECSEntityFieldEnum = exports.BaseECSEntityField = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Entity Store Common Schema
 *   version: 1
 */

const EntityType = exports.EntityType = _zod.z.enum(['user', 'host', 'service', 'generic']);
const EntityTypeEnum = exports.EntityTypeEnum = EntityType.enum;
const BaseECSEntityField = exports.BaseECSEntityField = _zod.z.enum(['user', 'host', 'service', 'entity']);
const BaseECSEntityFieldEnum = exports.BaseECSEntityFieldEnum = BaseECSEntityField.enum;
const IndexPattern = exports.IndexPattern = _zod.z.string();
const EngineStatus = exports.EngineStatus = _zod.z.enum(['installing', 'started', 'stopped', 'updating', 'error']);
const EngineStatusEnum = exports.EngineStatusEnum = EngineStatus.enum;
const EngineDescriptor = exports.EngineDescriptor = _zod.z.object({
  type: EntityType,
  indexPattern: IndexPattern,
  status: EngineStatus,
  filter: _zod.z.string().optional(),
  fieldHistoryLength: _zod.z.number().int(),
  lookbackPeriod: _zod.z.string().regex(/[smdh]$/).optional().default('24h'),
  timestampField: _zod.z.string().optional(),
  timeout: _zod.z.string().regex(/[smdh]$/).optional().default('180s'),
  frequency: _zod.z.string().regex(/[smdh]$/).optional().default('1m'),
  delay: _zod.z.string().regex(/[smdh]$/).optional().default('1m'),
  docsPerSecond: _zod.z.number().int().optional(),
  error: _zod.z.object({
    message: _zod.z.string(),
    action: _zod.z.literal('init')
  }).optional()
});
const TransformStatsMetadata = exports.TransformStatsMetadata = _zod.z.object({
  pages_processed: _zod.z.number().int(),
  documents_processed: _zod.z.number().int(),
  documents_indexed: _zod.z.number().int(),
  documents_deleted: _zod.z.number().int().optional(),
  trigger_count: _zod.z.number().int(),
  index_time_in_ms: _zod.z.number().int(),
  index_total: _zod.z.number().int(),
  index_failures: _zod.z.number().int(),
  search_time_in_ms: _zod.z.number().int(),
  search_total: _zod.z.number().int(),
  search_failures: _zod.z.number().int(),
  processing_time_in_ms: _zod.z.number().int(),
  processing_total: _zod.z.number().int(),
  delete_time_in_ms: _zod.z.number().int().optional(),
  exponential_avg_checkpoint_duration_ms: _zod.z.number().int(),
  exponential_avg_documents_indexed: _zod.z.number().int(),
  exponential_avg_documents_processed: _zod.z.number().int()
});
const Metadata = exports.Metadata = TransformStatsMetadata;
const EngineComponentResource = exports.EngineComponentResource = _zod.z.enum(['entity_engine', 'entity_definition', 'index', 'component_template', 'index_template', 'ingest_pipeline', 'enrich_policy', 'task', 'transform']);
const EngineComponentResourceEnum = exports.EngineComponentResourceEnum = EngineComponentResource.enum;
const EngineComponentStatus = exports.EngineComponentStatus = _zod.z.object({
  id: _zod.z.string(),
  installed: _zod.z.boolean(),
  metadata: Metadata.optional(),
  resource: EngineComponentResource,
  health: _zod.z.enum(['green', 'yellow', 'red', 'unavailable', 'unknown']).optional(),
  errors: _zod.z.array(_zod.z.object({
    title: _zod.z.string().optional(),
    message: _zod.z.string().optional()
  })).optional()
});
const StoreStatus = exports.StoreStatus = _zod.z.enum(['not_installed', 'installing', 'running', 'stopped', 'error']);
const StoreStatusEnum = exports.StoreStatusEnum = StoreStatus.enum;
const InspectQuery = exports.InspectQuery = _zod.z.object({
  response: _zod.z.array(_zod.z.string()),
  dsl: _zod.z.array(_zod.z.string())
});

/**
 * Interval in which enrich policy runs. For example, `"1h"` means the rule runs every hour. Must be less than or equal to half the duration of the lookback period,
 */

const Interval = exports.Interval = _zod.z.string().regex(/^[1-9]\d*[smh]$/);