"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterPrivilegesForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _remote_clusters_combo_box = require("./remote_clusters_combo_box");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fromOption = option => option.label;
const toOption = value => ({
  label: value
});
const RemoteClusterPrivilegesForm = ({
  isRoleReadOnly,
  remoteClusters = [],
  formIndex,
  validator,
  remoteClusterPrivilege,
  availableRemoteClusterPrivileges,
  onChange,
  onDelete
}) => {
  var _ref2;
  const onCreateClusterOption = (0, _react2.useCallback)(option => {
    var _ref;
    const nextClusters = ((_ref = [...remoteClusterPrivilege.clusters]) !== null && _ref !== void 0 ? _ref : []).concat([option]);
    onChange({
      ...remoteClusterPrivilege,
      clusters: nextClusters
    });
  }, [remoteClusterPrivilege, onChange]);
  const onClustersChange = (0, _react2.useCallback)(nextOptions => {
    const clusters = nextOptions.map(fromOption);
    onChange({
      ...remoteClusterPrivilege,
      clusters
    });
  }, [onChange, remoteClusterPrivilege]);
  const onPrivilegeChange = (0, _react2.useCallback)(newPrivileges => {
    onChange({
      ...remoteClusterPrivilege,
      privileges: newPrivileges.map(fromOption)
    });
  }, [remoteClusterPrivilege, onChange]);
  return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    className: "remote-cluster-privilege-form"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGrid, {
    css: (0, _react.css)`
                grid-template-columns: repeat(2, minmax(0, 1fr));
                @media (max-width: ${_uiTheme.euiThemeVars.euiBreakpoints.s}px) {
                  grid-template-columns: repeat(1, minmax(0, 1fr));
                }
              `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.remoteClusterPrivilegeForm.clustersFormRowLabel",
      defaultMessage: "Remote clusters"
    }),
    fullWidth: true
  }, validator.validateRemoteClusterPrivilegeClusterField(remoteClusterPrivilege)), /*#__PURE__*/_react2.default.createElement(_remote_clusters_combo_box.RemoteClusterComboBox, {
    "data-test-subj": `remoteClusterClustersInput${formIndex}`,
    selectedOptions: ((_ref2 = [...remoteClusterPrivilege.clusters]) !== null && _ref2 !== void 0 ? _ref2 : []).map(toOption),
    onCreateOption: onCreateClusterOption,
    onChange: onClustersChange,
    isDisabled: isRoleReadOnly,
    placeholder: _i18n.i18n.translate('xpack.security.management.editRole.remoteClusterPrivilegeForm.clustersPlaceholder', {
      defaultMessage: 'Add a remote cluster…'
    }),
    remoteClusters: remoteClusters,
    type: "remote_cluster",
    fullWidth: true
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.remoteClusterPrivilegeForm.privilegesFormRowLabel",
      defaultMessage: "Privileges"
    }),
    fullWidth: true
  }, validator.validateRemoteClusterPrivilegePrivilegesField(remoteClusterPrivilege)), /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": `remoteClusterPrivilegesInput${formIndex}`,
    options: availableRemoteClusterPrivileges.map(toOption),
    selectedOptions: remoteClusterPrivilege.privileges.map(toOption),
    onChange: onPrivilegeChange,
    isDisabled: isRoleReadOnly,
    placeholder: _i18n.i18n.translate('xpack.security.management.editRole.remoteClusterPrivilegeForm.privilegesPlaceholder', {
      defaultMessage: 'Add a privilege…'
    }),
    fullWidth: true
  })))))), !isRoleReadOnly && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.remoteClusterPrivilegeForm.deleteRemoteClusterPrivilegeAriaLabel', {
      defaultMessage: 'Delete remote cluster privilege'
    }),
    color: "danger",
    onClick: onDelete,
    iconType: "trash",
    "data-test-subj": `deleteRemoteClusterPrivilegesButton${formIndex}`
  }))));
};
exports.RemoteClusterPrivilegesForm = RemoteClusterPrivilegesForm;