"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceProvider = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _endpoint_model_info = require("./endpoint_model_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServiceProvider = ({
  service,
  endpointInfo
}) => {
  const provider = _inferenceEndpointUiCommon.SERVICE_PROVIDERS[service];
  return provider ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": `table-column-service-provider-${service}`,
    type: provider.icon,
    style: {
      marginRight: '8px'
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, provider.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_endpoint_model_info.EndpointModelInfo, {
    endpointInfo: endpointInfo
  }))))) : /*#__PURE__*/_react.default.createElement("span", null, service);
};
exports.ServiceProvider = ServiceProvider;