"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _i18n = require("@kbn/i18n");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _use_api_key = require("../hooks/api/use_api_key");
var _use_kibana = require("../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_KEY_MASK = '•'.repeat(60);
const ApiKeyFormContent = ({
  apiKey,
  status,
  toggleApiKeyVisibility,
  updateApiKey,
  manageKeysLink
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "flexStart",
    responsive: false
  }, apiKey ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_searchSharedUi.FormInfoField, {
    value: status === _searchApiKeysComponents.Status.showPreviewKey ? apiKey : API_KEY_MASK,
    copyValue: apiKey,
    dataTestSubj: "searchHomepageApiKeyFormAPIKey",
    copyValueDataTestSubj: "searchHomepageAPIKeyButtonCopy",
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: status === _searchApiKeysComponents.Status.showPreviewKey ? 'eyeClosed' : 'eye',
      color: "text",
      onClick: toggleApiKeyVisibility,
      "data-test-subj": "searchHomepageShowAPIKeyButton",
      "aria-label": _i18n.i18n.translate('xpack.searchHomepage.apiKeyForm.showApiKey', {
        defaultMessage: 'Show API key'
      })
    })]
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    size: "s",
    iconSide: "left",
    iconType: "key",
    onClick: () => setShowFlyout(true),
    "data-test-subj": "createApiKeyButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.apiKeyForm.createButton",
    defaultMessage: "Create API key"
  })), showFlyout && /*#__PURE__*/_react.default.createElement(_searchApiKeysComponents.ApiKeyFlyoutWrapper, {
    onCancel: () => setShowFlyout(false),
    onSuccess: ({
      id,
      encoded
    }) => {
      updateApiKey({
        id,
        encoded
      });
      setShowFlyout(false);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "gear",
    href: manageKeysLink,
    "data-test-subj": "manageApiKeysButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.apiKeyForm.manageKeysButton",
    defaultMessage: "Manage"
  }))));
};
const ApiKeysUserPrivilegesError = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s",
  justifyContent: "flexStart",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 0
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  "data-test-subj": "apiKeyFormNoUserPrivileges"
}, _i18n.i18n.translate('xpack.searchHomepage.apiKeyForm.noUserPrivileges', {
  defaultMessage: 'Contact an administrator to manage API keys'
}))));
const ApiKeyForm = () => {
  var _share$url, _data$apiKeys$length, _data$apiKeys, _data$apiKeys$length2, _data$apiKeys2;
  const {
    apiKey,
    status,
    updateApiKey,
    toggleApiKeyVisibility
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const {
    data
  } = (0, _use_api_key.useGetApiKeys)();
  const {
    share
  } = (0, _use_kibana.useKibana)().services;
  const locator = share === null || share === void 0 ? void 0 : (_share$url = share.url) === null || _share$url === void 0 ? void 0 : _share$url.locators.get('MANAGEMENT_APP_LOCATOR');
  const manageKeysLink = locator === null || locator === void 0 ? void 0 : locator.useUrl({
    sectionId: 'security',
    appId: 'api_keys'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.searchHomepage.connectToElasticsearch.apiKeysLabel', {
    defaultMessage: 'API keys'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "activeApiKeysBadge",
    color: ((_data$apiKeys$length = data === null || data === void 0 ? void 0 : (_data$apiKeys = data.apiKeys) === null || _data$apiKeys === void 0 ? void 0 : _data$apiKeys.length) !== null && _data$apiKeys$length !== void 0 ? _data$apiKeys$length : 0) > 0 ? 'success' : 'warning'
  }, (_data$apiKeys$length2 = data === null || data === void 0 ? void 0 : (_data$apiKeys2 = data.apiKeys) === null || _data$apiKeys2 === void 0 ? void 0 : _data$apiKeys2.length) !== null && _data$apiKeys$length2 !== void 0 ? _data$apiKeys$length2 : 0, " active")))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, status === _searchApiKeysComponents.Status.showUserPrivilegesError ? /*#__PURE__*/_react.default.createElement(ApiKeysUserPrivilegesError, null) : /*#__PURE__*/_react.default.createElement(ApiKeyFormContent, {
    apiKey: apiKey,
    status: status,
    updateApiKey: updateApiKey,
    toggleApiKeyVisibility: toggleApiKeyVisibility,
    manageKeysLink: manageKeysLink
  })));
};
exports.ApiKeyForm = ApiKeyForm;