"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationFormItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _connector_configuration_field = require("./connector_configuration_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ConnectorConfigurationFormItems = ({
  isLoading,
  items,
  hasDocumentLevelSecurityEnabled,
  setConfigEntry
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, items.map(configEntry => {
    const {
      default_value: defaultValue,
      depends_on: dependencies,
      key,
      display,
      isValid,
      label,
      sensitive,
      tooltip,
      validationErrors
    } = configEntry;
    if (key === 'use_document_level_security' && !hasDocumentLevelSecurityEnabled) {
      return null;
    }
    const helpText = defaultValue ? _i18n.i18n.translate('searchConnectors.configurationConnector.config.defaultValue', {
      defaultMessage: 'If left empty, the default value {defaultValue} will be used.',
      values: {
        defaultValue
      }
    }) : '';
    // toggle and sensitive textarea labels go next to the element, not in the row
    const rowLabel = display === _.DisplayType.TOGGLE || display === _.DisplayType.TEXTAREA && sensitive ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : tooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("div", {
      role: "tooltip"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: tooltip
    })))) : /*#__PURE__*/_react.default.createElement("p", null, label);
    if ((dependencies === null || dependencies === void 0 ? void 0 : dependencies.length) > 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: key
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        color: "subdued",
        borderRadius: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: rowLabel,
        helpText: helpText,
        error: validationErrors,
        isInvalid: !isValid,
        "data-test-subj": `entSearchContent-connector-configuration-formrow-${key}`
      }, /*#__PURE__*/_react.default.createElement(_connector_configuration_field.ConnectorConfigurationField, {
        configEntry: configEntry,
        isLoading: isLoading,
        setConfigValue: value => {
          setConfigEntry(configEntry.key, value);
        }
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: rowLabel,
      helpText: helpText,
      error: validationErrors,
      isInvalid: !isValid,
      "data-test-subj": `entSearchContent-connector-configuration-formrow-${key}`
    }, /*#__PURE__*/_react.default.createElement(_connector_configuration_field.ConnectorConfigurationField, {
      configEntry: configEntry,
      isLoading: isLoading,
      setConfigValue: value => {
        setConfigEntry(configEntry.key, value);
      }
    })));
  }));
};
exports.ConnectorConfigurationFormItems = ConnectorConfigurationFormItems;