"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportModeControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createNewCopiesDisabled = {
  id: 'createNewCopiesDisabled',
  text: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.disabledTitle', {
    defaultMessage: 'Check for existing objects'
  }),
  tooltip: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.disabledText', {
    defaultMessage: 'Check if objects were previously copied or imported.'
  })
};
const createNewCopiesEnabled = {
  id: 'createNewCopiesEnabled',
  text: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.enabledTitle', {
    defaultMessage: 'Create new objects with random IDs'
  }),
  tooltip: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.enabledText', {
    defaultMessage: 'Use this option to create one or more copies of the object.'
  })
};
const overwriteEnabled = {
  id: 'overwriteEnabled',
  label: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.overwrite.enabledLabel', {
    defaultMessage: 'Automatically overwrite conflicts'
  })
};
const overwriteDisabled = {
  id: 'overwriteDisabled',
  label: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.overwrite.disabledLabel', {
    defaultMessage: 'Request action on conflict'
  })
};
const importOptionsTitle = _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.importOptionsTitle', {
  defaultMessage: 'Import options'
});
const createLabel = ({
  text,
  tooltip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, text)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: tooltip,
  position: "left",
  type: "info"
})));
const ImportModeControl = ({
  initialValues,
  updateSelection
}) => {
  const [createNewCopies, setCreateNewCopies] = (0, _react.useState)(initialValues.createNewCopies);
  const [overwrite, setOverwrite] = (0, _react.useState)(initialValues.overwrite);
  const onChange = partial => {
    if (partial.createNewCopies !== undefined) {
      setCreateNewCopies(partial.createNewCopies);
    } else if (partial.overwrite !== undefined) {
      setOverwrite(partial.overwrite);
    }
    updateSelection({
      createNewCopies,
      overwrite,
      ...partial
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("span", null, importOptionsTitle))
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: createNewCopiesDisabled.id,
    label: createLabel(createNewCopiesDisabled),
    checked: !createNewCopies,
    onChange: () => onChange({
      createNewCopies: false
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    name: "importModeOverwrite",
    options: [overwriteEnabled, overwriteDisabled],
    idSelected: overwrite ? overwriteEnabled.id : overwriteDisabled.id,
    onChange: id => onChange({
      overwrite: id === overwriteEnabled.id
    }),
    disabled: createNewCopies,
    "data-test-subj": 'savedObjectsManagement-importModeControl-overwriteRadioGroup'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: createNewCopiesEnabled.id,
    label: createLabel(createNewCopiesEnabled),
    checked: createNewCopies,
    onChange: () => onChange({
      createNewCopies: true
    })
  }));
};
exports.ImportModeControl = ImportModeControl;