"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Label = Label;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Label({
  value,
  prepend,
  append
}) {
  const {
    label,
    color,
    icon
  } = (0, _utils.getColorLabel)(value);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: color
  }, prepend, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "s",
    color: color
  }), label, append);
}