"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToolsServiceStartMock = exports.createToolProviderMock = exports.createScopedPublicToolRegistryMock = exports.createMockedTool = exports.createMockedExecutableTool = exports.createInternalToolRegistryMock = void 0;
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createToolProviderMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn()
  };
};
exports.createToolProviderMock = createToolProviderMock;
const createInternalToolRegistryMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn(),
    asPublicRegistry: jest.fn().mockImplementation(() => createToolProviderMock()),
    asScopedPublicRegistry: jest.fn().mockImplementation(() => createScopedPublicToolRegistryMock())
  };
};
exports.createInternalToolRegistryMock = createInternalToolRegistryMock;
const createScopedPublicToolRegistryMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn()
  };
};
exports.createScopedPublicToolRegistryMock = createScopedPublicToolRegistryMock;
const createToolsServiceStartMock = () => {
  return {
    registry: createInternalToolRegistryMock()
  };
};
exports.createToolsServiceStartMock = createToolsServiceStartMock;
const createMockedTool = (parts = {}) => {
  return {
    id: 'test-tool',
    description: 'test description',
    schema: _zod.z.object({}),
    meta: {
      providerId: _onechatCommon.builtinToolProviderId,
      tags: ['tag-1', 'tag-2']
    },
    ...parts,
    handler: jest.fn(parts.handler)
  };
};
exports.createMockedTool = createMockedTool;
const createMockedExecutableTool = (parts = {}) => {
  return {
    id: 'test-tool',
    description: 'test description',
    schema: _zod.z.object({}),
    meta: {
      providerId: _onechatCommon.builtinToolProviderId,
      tags: ['tag-1', 'tag-2']
    },
    ...parts,
    execute: jest.fn(parts.execute)
  };
};
exports.createMockedExecutableTool = createMockedExecutableTool;