"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _uuid = require("uuid");
var _onechatCommon = require("@kbn/onechat-common");
var _converters = require("./converters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createClient = ({
  storage,
  user
}) => {
  return new ConversationClientImpl({
    storage,
    user
  });
};
exports.createClient = createClient;
class ConversationClientImpl {
  constructor({
    storage,
    user
  }) {
    (0, _defineProperty2.default)(this, "storage", void 0);
    (0, _defineProperty2.default)(this, "user", void 0);
    this.storage = storage;
    this.user = user;
  }
  async list(options = {}) {
    const agentId = options.agentId ? (0, _onechatCommon.toStructuredAgentIdentifier)(options.agentId).agentId : undefined;
    const response = await this.storage.getClient().search({
      track_total_hits: false,
      size: 100,
      query: {
        bool: {
          must: [{
            term: {
              user_id: this.user.id
            }
          }, ...(agentId ? [{
            term: {
              agent_id: agentId
            }
          }] : [])]
        }
      }
    });
    return response.hits.hits.map(hit => (0, _converters.fromEs)(hit));
  }
  async get(conversationId) {
    const document = await this.storage.getClient().get({
      id: conversationId
    });
    if (!hasAccess({
      conversation: document,
      user: this.user
    })) {
      throw (0, _onechatCommon.createConversationNotFoundError)({
        conversationId
      });
    }
    return (0, _converters.fromEs)(document);
  }
  async create(conversation) {
    var _conversation$id;
    const now = new Date();
    const id = (_conversation$id = conversation.id) !== null && _conversation$id !== void 0 ? _conversation$id : (0, _uuid.v4)();
    const attributes = (0, _converters.createRequestToEs)({
      conversation,
      currentUser: this.user,
      creationDate: now
    });
    await this.storage.getClient().index({
      id,
      document: attributes
    });
    return this.get(id);
  }
  async update(conversationUpdate) {
    const now = new Date();
    const document = await this.storage.getClient().get({
      id: conversationUpdate.id
    });
    if (!hasAccess({
      conversation: document,
      user: this.user
    })) {
      throw (0, _onechatCommon.createConversationNotFoundError)({
        conversationId: conversationUpdate.id
      });
    }
    const storedConversation = (0, _converters.fromEs)(document);
    const updatedConversation = (0, _converters.updateConversation)({
      conversation: storedConversation,
      update: conversationUpdate,
      updateDate: now
    });
    const attributes = (0, _converters.toEs)(updatedConversation);
    await this.storage.getClient().index({
      id: conversationUpdate.id,
      document: attributes
    });
    return this.get(conversationUpdate.id);
  }
}
const hasAccess = ({
  conversation,
  user
}) => {
  return conversation._source.user_id === user.id;
};