"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultAgentProvider = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns an agent provider exposing the default onechat agent.
 */
const createDefaultAgentProvider = () => {
  const provider = {
    id: _onechatCommon.OneChatDefaultAgentProviderId,
    has: ({
      agentId
    }) => {
      return agentId === _onechatCommon.OneChatDefaultAgentId;
    },
    get: ({
      agentId
    }) => {
      if (agentId === _onechatCommon.OneChatDefaultAgentId) {
        return createDefaultAgentDescriptor();
      }
      throw (0, _onechatCommon.createAgentNotFoundError)({
        agentId: (0, _onechatCommon.toSerializedAgentIdentifier)(agentId)
      });
    },
    list: () => {
      return [createDefaultAgentDescriptor()];
    }
  };
  return provider;
};
exports.createDefaultAgentProvider = createDefaultAgentProvider;
const createDefaultAgentDescriptor = () => {
  return {
    type: _onechatCommon.AgentType.conversational,
    id: _onechatCommon.OneChatDefaultAgentId,
    description: 'Default onechat agent',
    handler: (0, _handler.createHandler)({
      agentId: _onechatCommon.OneChatDefaultAgentId
    })
  };
};