"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _tools = require("./tools");
var _agents = require("./agents");
var _chat = require("./chat");
var _conversations = require("./conversations");
var _mcp = require("./mcp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = dependencies => {
  (0, _tools.registerToolsRoutes)(dependencies);
  (0, _agents.registerAgentRoutes)(dependencies);
  (0, _chat.registerChatRoutes)(dependencies);
  (0, _conversations.registerConversationRoutes)(dependencies);
  (0, _mcp.registerMCPRoutes)(dependencies);
};
exports.registerRoutes = registerRoutes;