"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _features = require("./features");
var _routes = require("./routes");
var _services = require("./services");
var _tools = require("./tools");
var _ui_settings = require("./ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OnechatPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    // @ts-expect-error unused for now
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "serviceManager", new _services.ServiceManager());
    this.logger = context.logger.get();
    this.config = context.config.get();
  }
  setup(coreSetup, pluginsSetup) {
    const serviceSetups = this.serviceManager.setupServices({
      logger: this.logger.get('services')
    });
    (0, _features.registerFeatures)({
      features: pluginsSetup.features
    });
    (0, _tools.registerTools)({
      tools: serviceSetups.tools
    });
    (0, _ui_settings.registerUISettings)({
      uiSettings: coreSetup.uiSettings
    });
    const router = coreSetup.http.createRouter();
    (0, _routes.registerRoutes)({
      router,
      coreSetup,
      logger: this.logger,
      getInternalServices: () => {
        const services = this.serviceManager.internalStart;
        if (!services) {
          throw new Error('getInternalServices called before service init');
        }
        return services;
      }
    });
    return {
      tools: {
        register: serviceSetups.tools.register.bind(serviceSetups.tools),
        registerProvider: serviceSetups.tools.registerProvider.bind(serviceSetups.tools)
      }
    };
  }
  start({
    elasticsearch,
    security
  }, {
    actions,
    inference
  }) {
    const startServices = this.serviceManager.startServices({
      logger: this.logger.get('services'),
      security,
      elasticsearch,
      actions,
      inference
    });
    const {
      tools,
      agents,
      runnerFactory
    } = startServices;
    const runner = runnerFactory.getRunner();
    return {
      tools: {
        registry: tools.registry.asPublicRegistry(),
        execute: runner.runTool.bind(runner),
        asScoped: ({
          request
        }) => {
          return {
            registry: tools.registry.asScopedPublicRegistry({
              request
            }),
            execute: args => {
              return runner.runTool({
                ...args,
                request
              });
            }
          };
        }
      },
      agents: {
        registry: agents.registry.asPublicRegistry(),
        execute: async args => {
          return agents.execute(args);
        }
      }
    };
  }
  stop() {}
}
exports.OnechatPlugin = OnechatPlugin;