"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * uiSettings definitions for Navigation
 */
const getUiSettings = (core, logger) => {
  return {
    [_constants.DEFAULT_ROUTE_UI_SETTING_ID]: {
      name: _i18n.i18n.translate('navigation.ui_settings.params.defaultRoute.defaultRouteTitle', {
        defaultMessage: 'Default route'
      }),
      getValue: async ({
        request
      } = {}) => {
        const [_, {
          spaces
        }] = await core.getStartServices();
        if (!spaces || !request) {
          return _constants.DEFAULT_ROUTES.classic;
        }
        try {
          var _activeSpace$solution, _DEFAULT_ROUTES$solut;
          if (!request.auth.isAuthenticated) return _constants.DEFAULT_ROUTES.classic;
          const activeSpace = await spaces.spacesService.getActiveSpace(request);
          const solution = (_activeSpace$solution = activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution) !== null && _activeSpace$solution !== void 0 ? _activeSpace$solution : 'classic';
          return (_DEFAULT_ROUTES$solut = _constants.DEFAULT_ROUTES[solution]) !== null && _DEFAULT_ROUTES$solut !== void 0 ? _DEFAULT_ROUTES$solut : _constants.DEFAULT_ROUTES.classic;
        } catch (e) {
          logger.error(`Failed to retrieve active space: ${e.message}`);
          return _constants.DEFAULT_ROUTES.classic;
        }
      },
      schema: _configSchema.schema.string({
        validate(value) {
          if (!value.startsWith('/') || !(0, _std.isRelativeUrl)(value)) {
            return _i18n.i18n.translate('navigation.uiSettings.defaultRoute.defaultRouteIsRelativeValidationMessage', {
              defaultMessage: 'Must be a relative URL.'
            });
          }
        }
      }),
      description: _i18n.i18n.translate('navigation.uiSettings.defaultRoute.defaultRouteText', {
        defaultMessage: 'This setting specifies the default route when opening Kibana. ' + 'You can use this setting to modify the landing page when opening Kibana. ' + 'The route must be a relative URL.'
      })
    }
  };
};
exports.getUiSettings = getUiSettings;