"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _page_template = require("./page_template");
var _components = require("../../components");
var _use_clusters = require("../hooks/use_clusters");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CODE_PATHS = [_constants.CODE_PATH_ELASTICSEARCH];
const LoadingPage = ({
  staticLoadingState
}) => {
  const {
    clusters,
    loaded
  } = (0, _use_clusters.useClusters)(null, undefined, CODE_PATHS);
  const title = _i18n.i18n.translate('xpack.monitoring.loading.pageTitle', {
    defaultMessage: 'Loading'
  });
  if (staticLoadingState) {
    return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
      title: title
    }, /*#__PURE__*/_react.default.createElement(_components.PageLoading, null));
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    title: title
  }, loaded === false ? /*#__PURE__*/_react.default.createElement(_components.PageLoading, null) : renderRedirections(clusters));
};
exports.LoadingPage = LoadingPage;
const renderRedirections = clusters => {
  if (!clusters || !clusters.length) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "/no-data"
    });
  }
  if (clusters.length === 1) {
    // Bypass the cluster listing if there is just 1 cluster
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "/overview"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/home"
  });
};