"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomalyChartsReactEmbeddableFactory = void 0;
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _ = require("..");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _initialize_anomaly_charts_controls = require("./initialize_anomaly_charts_controls");
var _lazy_anomaly_charts_container = require("./lazy_anomaly_charts_container");
var _get_anomaly_charts_services_dependencies = require("./get_anomaly_charts_services_dependencies");
var _build_data_view_publishing_api = require("../common/build_data_view_publishing_api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAnomalyChartsReactEmbeddableFactory = getStartServices => {
  const factory = {
    type: _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
        throw new Error('Parent API does not have execution context');
      }
      const [coreStartServices, pluginsStartServices] = await getStartServices();
      const anomalyChartsDependencies = await (0, _get_anomaly_charts_services_dependencies.getAnomalyChartsServiceDependencies)(coreStartServices, pluginsStartServices);
      const [,, mlServices] = anomalyChartsDependencies;
      const subscriptions = new _rxjs.Subscription();
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState.rawState);
      const chartsManager = (0, _initialize_anomaly_charts_controls.initializeAnomalyChartsControls)(initialState.rawState, titleManager.api, parentApi);
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...timeRangeManager.getLatestState(),
            ...chartsManager.getLatestState()
          },
          references: []
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, timeRangeManager.anyStateChange$, chartsManager.anyStateChange$),
        getComparators: () => {
          return {
            ..._presentationPublishing.titleComparators,
            ..._presentationPublishing.timeRangeComparators,
            ..._initialize_anomaly_charts_controls.anomalyChartsComparators
          };
        },
        onReset: lastSaved => {
          timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          if (lastSaved) chartsManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        }
      });
      const api = finalizeApi({
        isEditingEnabled: () => true,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.ml.components.mlAnomalyExplorerEmbeddable.typeDisplayName', {
          defaultMessage: 'anomaly charts'
        }),
        onEdit: async () => {
          try {
            const {
              resolveEmbeddableAnomalyChartsUserInput
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_charts_setup_flyout')));
            const result = await resolveEmbeddableAnomalyChartsUserInput(coreStartServices, pluginsStartServices, parentApi, uuid, {
              ...titleManager.getLatestState(),
              ...chartsManager.getLatestState()
            });
            chartsManager.api.updateUserInput(result);
          } catch (e) {
            // eslint-disable-next-line no-console
            console.error(e);
            return Promise.reject();
          }
        },
        ...titleManager.api,
        ...timeRangeManager.api,
        ...chartsManager.api,
        ...chartsManager.dataLoadingApi,
        ...unsavedChangesApi,
        dataViews$: (0, _build_data_view_publishing_api.buildDataViewPublishingApi)({
          anomalyDetectorService: mlServices.anomalyDetectorService,
          dataViewsService: pluginsStartServices.data.dataViews
        }, {
          jobIds: chartsManager.api.jobIds$
        }, subscriptions),
        serializeState
      });
      const appliedTimeRange$ = (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.map)(fetchContext => fetchContext.timeRange), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default));
      const {
        onRenderComplete,
        onLoading,
        onError
      } = chartsManager.dataLoadingApi;
      const contextServices = {
        mlServices: {
          ...mlServices
        },
        ...coreStartServices,
        ...pluginsStartServices
      };
      return {
        api,
        Component: () => {
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          (0, _use_embeddable_execution_context.useReactEmbeddableExecutionContext)(coreStartServices.executionContext, parentApi.executionContext, _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE, uuid);
          (0, _useUnmount.default)(() => {
            chartsManager.cleanup();
            subscriptions.unsubscribe();
          });
          const {
            euiTheme
          } = (0, _eui.useEuiTheme)();
          return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStartServices, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
            services: contextServices
          }, /*#__PURE__*/_react.default.createElement("div", {
            css: (0, _react2.css)`
                    width: 100%;
                    padding: ${euiTheme.size.xs};
                    overflow-y: auto;
                  `,
            "data-test-subj": "mlAnomalySwimlaneEmbeddableWrapper"
          }, /*#__PURE__*/_react.default.createElement(_lazy_anomaly_charts_container.LazyAnomalyChartsContainer, {
            id: uuid,
            severityThreshold: initialState.rawState.severityThreshold,
            api: api,
            services: anomalyChartsDependencies,
            onLoading: onLoading,
            onRenderComplete: onRenderComplete,
            onError: onError,
            timeRange$: appliedTimeRange$
          }))));
        }
      };
    }
  };
  return factory;
};
exports.getAnomalyChartsReactEmbeddableFactory = getAnomalyChartsReactEmbeddableFactory;