"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsTabContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobsTabContent = ({
  module
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const jobConfigsWithDatafeeds = (0, _react.useMemo)(() => module.datafeeds.map(({
    job_id: jobId,
    config
  }) => {
    const job = module.jobs.find(j => j.id === jobId);
    return {
      ...job,
      config: {
        ...job.config,
        datafeed_config: config
      }
    };
  }), [module]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobConfigsWithDatafeeds.map(job => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: job.id,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m"
      }, /*#__PURE__*/_react.default.createElement("b", null, job.id)),
      css: {
        padding: `0 ${euiTheme.size.m}`
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, job.config.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true,
      overflowHeight: "600px",
      "data-test-subj": "mlPreconfigJobsQueryBlock"
    }, JSON.stringify(job.config, null, 2))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  }));
};
exports.JobsTabContent = JobsTabContent;