"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobsApiProvider = void 0;
exports.useJobsApiService = useJobsApiService;
var _react = require("react");
var _kibana = require("../../contexts/kibana");
var _app = require("../../../../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobsApiProvider = httpService => ({
  jobsSummary(jobIds) {
    const body = JSON.stringify({
      jobIds
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/jobs_summary`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  jobIdsWithGeo() {
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/jobs_with_geo`,
      method: 'GET',
      version: '1'
    });
  },
  jobsWithTimerange(dateFormatTz) {
    const body = JSON.stringify({
      dateFormatTz
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/jobs_with_time_range`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  jobForCloning(jobId, retainCreatedBy = false) {
    const body = JSON.stringify({
      jobId,
      retainCreatedBy
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/job_for_cloning`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  jobs(jobIds) {
    const body = JSON.stringify({
      jobIds
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/jobs`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  groups() {
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/groups`,
      method: 'GET',
      version: '1'
    });
  },
  updateGroups(updatedJobs) {
    const body = JSON.stringify({
      jobs: updatedJobs
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/update_groups`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  forceStartDatafeeds(datafeedIds, start, end) {
    const body = JSON.stringify({
      datafeedIds,
      start,
      end
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/force_start_datafeeds`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  stopDatafeeds(datafeedIds) {
    const body = JSON.stringify({
      datafeedIds
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/stop_datafeeds`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  deleteJobs(jobIds, deleteUserAnnotations, deleteAlertingRules) {
    const body = JSON.stringify({
      jobIds,
      deleteUserAnnotations,
      deleteAlertingRules
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/delete_jobs`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  closeJobs(jobIds) {
    const body = JSON.stringify({
      jobIds
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/close_jobs`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  resetJobs(jobIds, deleteUserAnnotations) {
    const body = JSON.stringify({
      jobIds,
      deleteUserAnnotations
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/reset_jobs`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  forceStopAndCloseJob(jobId) {
    const body = JSON.stringify({
      jobId
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/force_stop_and_close_job`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  jobAuditMessages({
    jobId,
    from,
    start,
    end
  }) {
    const jobIdString = jobId !== undefined ? `/${jobId}` : '';
    const query = {
      ...(from !== undefined ? {
        from
      } : {}),
      ...(start !== undefined && end !== undefined ? {
        start,
        end
      } : {})
    };
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/job_audit_messages/messages${jobIdString}`,
      method: 'GET',
      query,
      version: '1'
    });
  },
  clearJobAuditMessages(jobId, notificationIndices) {
    const body = JSON.stringify({
      jobId,
      notificationIndices
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/job_audit_messages/clear_messages`,
      method: 'PUT',
      body,
      version: '1'
    });
  },
  blockingJobTasks() {
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/blocking_jobs_tasks`,
      method: 'GET',
      version: '1'
    });
  },
  jobsExist(jobIds, allSpaces = false) {
    const body = JSON.stringify({
      jobIds,
      allSpaces
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/jobs_exist`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  jobsExist$(jobIds, allSpaces = false) {
    const body = JSON.stringify({
      jobIds,
      allSpaces
    });
    return httpService.http$({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/jobs_exist`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  newJobCaps(indexPatternTitle, isRollup = false) {
    const query = isRollup === true ? {
      rollup: true
    } : {};
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/new_job_caps/${indexPatternTitle}`,
      method: 'GET',
      query,
      version: '1'
    });
  },
  newJobLineChart(indexPatternTitle, timeField, start, end, intervalMs, query, aggFieldNamePairs, splitFieldName, splitFieldValue, runtimeMappings, indicesOptions) {
    const body = JSON.stringify({
      indexPatternTitle,
      timeField,
      start,
      end,
      intervalMs,
      query,
      aggFieldNamePairs,
      splitFieldName,
      splitFieldValue,
      runtimeMappings,
      indicesOptions
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/new_job_line_chart`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  newJobPopulationsChart(indexPatternTitle, timeField, start, end, intervalMs, query, aggFieldNamePairs, splitFieldName, runtimeMappings, indicesOptions) {
    const body = JSON.stringify({
      indexPatternTitle,
      timeField,
      start,
      end,
      intervalMs,
      query,
      aggFieldNamePairs,
      splitFieldName,
      runtimeMappings,
      indicesOptions
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/new_job_population_chart`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getAllJobAndGroupIds() {
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/all_jobs_and_group_ids`,
      method: 'GET',
      version: '1'
    });
  },
  getLookBackProgress(jobId, start, end) {
    const body = JSON.stringify({
      jobId,
      start,
      end
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/look_back_progress`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  categorizationFieldExamples(indexPatternTitle, query, size, field, timeField, start, end, analyzer, runtimeMappings, indicesOptions, includeExamples) {
    const body = JSON.stringify({
      indexPatternTitle,
      query,
      size,
      field,
      timeField,
      start,
      end,
      analyzer,
      runtimeMappings,
      indicesOptions,
      includeExamples
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/categorization_field_validation`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  topCategories(jobId, count) {
    const body = JSON.stringify({
      jobId,
      count
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/top_categories`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  revertModelSnapshot(jobId, snapshotId, replay, end, calendarEvents) {
    const body = JSON.stringify({
      jobId,
      snapshotId,
      replay,
      end,
      calendarEvents
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/revert_model_snapshot`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  datafeedPreview(datafeedId, job, datafeed) {
    const body = JSON.stringify({
      datafeedId,
      job,
      datafeed
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/datafeed_preview`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  bulkCreateJobs(jobs) {
    const body = JSON.stringify(jobs);
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/jobs/bulk_create`,
      method: 'POST',
      body,
      version: '1'
    });
  }
});
exports.jobsApiProvider = jobsApiProvider;
/**
 * Hooks for accessing {@link JobsApiService} in React components.
 */
function useJobsApiService() {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => jobsApiProvider(httpService), [httpService]);
}