"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpPopoverButton = exports.HelpPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _help_popover_styles = require("./help_popover_styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HelpPopoverButton = ({
  onClick,
  styles
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    iconType: "question",
    "aria-label": _i18n.i18n.translate('xpack.ml.helpPopover.ariaLabel', {
      defaultMessage: 'Help'
    }),
    onClick: onClick,
    css: styles
  });
};
exports.HelpPopoverButton = HelpPopoverButton;
const HelpPopover = ({
  anchorPosition,
  children,
  title,
  buttonCss
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    helpPopoverPanel,
    helpPopoverContent
  } = (0, _help_popover_styles.useHelpPopoverStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: anchorPosition,
    button: /*#__PURE__*/_react.default.createElement(HelpPopoverButton, {
      onClick: setIsPopoverOpen.bind(null, !isPopoverOpen),
      styles: buttonCss
    }),
    closePopover: setIsPopoverOpen.bind(null, false),
    isOpen: isPopoverOpen,
    ownFocus: true,
    panelProps: {
      css: helpPopoverPanel
    },
    panelPaddingSize: "none"
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: helpPopoverContent,
    size: "s",
    tabIndex: 0
  }, children));
};
exports.HelpPopover = HelpPopover;