"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = ConfirmDeleteModal;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConfirmDeleteModal({
  cancelDeletePipelines,
  deleteSelectedPipelines,
  selection,
  showConfirmDeleteModal
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!showConfirmDeleteModal) {
    return null;
  }
  const numPipelinesSelected = selection.length;
  const confirmText = numPipelinesSelected === 1 ? {
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelineWarningMessage",
      defaultMessage: "You cannot recover a deleted pipeline"
    }),
    button: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelineConfirmButtonLabel",
      defaultMessage: "Delete pipeline"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelineTitle",
      defaultMessage: "Delete pipeline \"{id}\"",
      values: {
        id: selection[0].id
      }
    })
  } : {
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelinesWarningMessage",
      defaultMessage: "You cannot recover deleted pipelines."
    }),
    button: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelinesConfirmButtonLabel",
      defaultMessage: "Delete {numPipelinesSelected} pipelines",
      values: {
        numPipelinesSelected
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelinesTitle",
      defaultMessage: "Delete {numPipelinesSelected} pipelines",
      values: {
        numPipelinesSelected
      }
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: confirmText.button,
    defaultFocusedButton: _eui.EUI_MODAL_CANCEL_BUTTON,
    onCancel: cancelDeletePipelines,
    onConfirm: deleteSelectedPipelines,
    title: confirmText.title,
    titleProps: {
      id: modalTitleId
    },
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement("p", null, confirmText.message));
}