"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PIPELINE_EDITOR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PIPELINE_EDITOR = exports.PIPELINE_EDITOR = {
  DELETE_PIPELINE_MODAL_MESSAGE: _i18n.i18n.translate('xpack.logstash.deletePipelineModalMessage', {
    defaultMessage: 'You cannot recover a deleted pipeline.'
  }),
  ID_REQUIRED_ERR_MSG: _i18n.i18n.translate('xpack.logstash.pipelineIdRequiredMessage', {
    defaultMessage: 'Pipeline ID is required'
  }),
  ID_FORMAT_ERR_MSG: _i18n.i18n.translate('xpack.logstash.idFormatErrorMessage', {
    defaultMessage: 'Pipeline ID must begin with a letter or underscore and contain only letters, underscores, dashes, hyphens, and numbers'
  }),
  QUEUE_TYPES: [{
    'data-test-subj': 'selectQueueType-memory',
    text: _i18n.i18n.translate('xpack.logstash.queueTypes.memoryLabel', {
      defaultMessage: 'memory'
    }),
    value: 'memory'
  }, {
    'data-test-subj': 'selectQueueType-persisted',
    text: _i18n.i18n.translate('xpack.logstash.queueTypes.persistedLabel', {
      defaultMessage: 'persisted'
    }),
    value: 'persisted'
  }],
  UNITS: [{
    'data-test-subj': 'selectQueueMaxBytesUnits-b',
    text: _i18n.i18n.translate('xpack.logstash.units.bytesLabel', {
      defaultMessage: 'bytes'
    }),
    value: 'b'
  }, {
    'data-test-subj': 'selectQueueMaxBytesUnits-kb',
    text: _i18n.i18n.translate('xpack.logstash.units.kilobytesLabel', {
      defaultMessage: 'kilobytes'
    }),
    value: 'kb'
  }, {
    'data-test-subj': 'selectQueueMaxBytesUnits-mb',
    text: _i18n.i18n.translate('xpack.logstash.units.megabytesLabel', {
      defaultMessage: 'megabytes'
    }),
    value: 'mb'
  }, {
    'data-test-subj': 'selectQueueMaxBytesUnits-gb',
    text: _i18n.i18n.translate('xpack.logstash.units.gigabytesLabel', {
      defaultMessage: 'gigabytes'
    }),
    value: 'gb'
  }, {
    'data-test-subj': 'selectQueueMaxBytesUnits-tb',
    text: _i18n.i18n.translate('xpack.logstash.units.terabytesLabel', {
      defaultMessage: 'terabytes'
    }),
    value: 'tb'
  }, {
    'data-test-subj': 'selectQueueMaxBytesUnits-pb',
    text: _i18n.i18n.translate('xpack.logstash.units.petabytesLabel', {
      defaultMessage: 'petabytes'
    }),
    value: 'pb'
  }]
};