"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fullscreenMiddleware = void 0;
var _lens_slice = require("./lens_slice");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullscreenMiddleware = storeDeps => store => {
  return next => action => {
    if (_lens_slice.setToggleFullscreen.match(action)) {
      const isFullscreen = store.getState().lens.isFullscreenDatasource;
      storeDeps.lensServices.chrome.setIsVisible(Boolean(isFullscreen));
    }
    next(action);
  };
};
exports.fullscreenMiddleware = fullscreenMiddleware;