"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _public4 = require("@kbn/ui-actions-plugin/public");
var _i18n = require("@kbn/i18n");
var _public5 = require("@kbn/core/public");
var _constants = require("../common/constants");
var _vis_type_alias = require("./vis_type_alias");
var _open_in_discover_action = require("./trigger_actions/open_in_discover_action");
var _in_app_embeddable_edit_trigger = require("./trigger_actions/open_lens_config/in_app_embeddable_edit/in_app_embeddable_edit_trigger");
var _saved_modal_lazy = require("./app_plugin/shared/saved_modal_lazy");
var _expressions = require("./expressions");
var _open_in_discover_drilldown = require("./trigger_actions/open_in_discover_drilldown");
var _locator = require("../common/locator/locator");
var _content_management = require("../common/content_management");
var _lens_custom_renderer_component = require("./react_embeddable/renderer/lens_custom_renderer_component");
var _constants2 = require("./trigger_actions/open_lens_config/constants");
var _csv_download_provider = require("./app_plugin/csv_download_provider/csv_download_provider");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class LensPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "datatableVisualization", void 0);
    (0, _defineProperty2.default)(this, "editorFrameService", void 0);
    (0, _defineProperty2.default)(this, "editorFrameSetup", void 0);
    (0, _defineProperty2.default)(this, "queuedVisualizations", []);
    (0, _defineProperty2.default)(this, "FormBasedDatasource", void 0);
    (0, _defineProperty2.default)(this, "TextBasedDatasource", void 0);
    (0, _defineProperty2.default)(this, "xyVisualization", void 0);
    (0, _defineProperty2.default)(this, "legacyMetricVisualization", void 0);
    (0, _defineProperty2.default)(this, "metricVisualization", void 0);
    (0, _defineProperty2.default)(this, "pieVisualization", void 0);
    (0, _defineProperty2.default)(this, "heatmapVisualization", void 0);
    (0, _defineProperty2.default)(this, "gaugeVisualization", void 0);
    (0, _defineProperty2.default)(this, "tagcloudVisualization", void 0);
    (0, _defineProperty2.default)(this, "topNavMenuEntries", []);
    (0, _defineProperty2.default)(this, "hasDiscoverAccess", false);
    (0, _defineProperty2.default)(this, "dataViewsService", void 0);
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "datasourceMap", void 0);
    (0, _defineProperty2.default)(this, "visualizationMap", void 0);
    // Note: this method will be overwritten in the setup flow
    (0, _defineProperty2.default)(this, "initEditorFrameService", async () => ({
      datasourceMap: {},
      visualizationMap: {}
    }));
  }
  setup(core, {
    urlForwarding,
    expressions,
    data,
    fieldFormats,
    embeddable,
    visualizations,
    charts,
    globalSearch,
    usageCollection,
    uiActionsEnhanced,
    share,
    contentManagement
  }) {
    const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
    const getStartServicesForEmbeddable = async () => {
      const {
        core: coreStart,
        plugins
      } = startServices();
      const [{
        getLensAttributeService,
        setUsageCollectionStart,
        initMemoizedErrorNotification
      }, {
        visualizationMap,
        datasourceMap
      }, eventAnnotationService] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./async_services'))), this.initEditorFrameService(), plugins.eventAnnotation.getService()]);
      if (plugins.usageCollection) {
        setUsageCollectionStart(plugins.usageCollection);
      }
      initMemoizedErrorNotification(coreStart);
      return {
        ...plugins,
        attributeService: getLensAttributeService(coreStart, plugins),
        capabilities: coreStart.application.capabilities,
        coreHttp: coreStart.http,
        coreStart,
        timefilter: plugins.data.query.timefilter.timefilter,
        expressionRenderer: plugins.expressions.ReactExpressionRenderer,
        documentToExpression: (doc, forceDSL) => this.editorFrameService.documentToExpression(doc, {
          dataViews: plugins.dataViews,
          storage: new _public.Storage(localStorage),
          uiSettings: core.uiSettings,
          timefilter: plugins.data.query.timefilter.timefilter,
          nowProvider: plugins.data.nowProvider,
          forceDSL,
          eventAnnotationService
        }),
        injectFilterReferences: data.query.filterManager.inject.bind(data.query.filterManager),
        visualizationMap,
        datasourceMap,
        theme: core.theme,
        uiSettings: core.uiSettings
      };
    };
    if (embeddable) {
      // Let Kibana know about the Lens embeddable
      embeddable.registerReactEmbeddableFactory(_constants.LENS_EMBEDDABLE_TYPE, async () => {
        const [deps, {
          createLensEmbeddableFactory
        }] = await Promise.all([getStartServicesForEmbeddable(), Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')))]);
        return createLensEmbeddableFactory(deps);
      });

      // Let Dashboard know about the Lens panel type
      embeddable.registerAddFromLibraryType({
        onAdd: async (container, savedObject) => {
          container.addNewPanel({
            panelType: _constants.LENS_EMBEDDABLE_TYPE,
            serializedState: {
              rawState: {
                savedObjectId: savedObject.id
              },
              references: savedObject.references
            }
          }, true);
        },
        savedObjectType: _constants.LENS_EMBEDDABLE_TYPE,
        savedObjectName: _i18n.i18n.translate('xpack.lens.mapSavedObjectLabel', {
          defaultMessage: 'Lens'
        }),
        getIconForSavedObject: () => _constants.LENS_ICON
      });
    }
    if (share) {
      this.locator = share.url.locators.create(new _locator.LensAppLocatorDefinition());
      share.registerShareIntegration('lens', (0, _csv_download_provider.downloadCsvLensShareProvider)({
        uiSettings: core.uiSettings,
        formatFactoryFn: () => startServices().plugins.fieldFormats.deserialize,
        atLeastGold: () => {
          var _startServices$plugin;
          let isGold = false;
          (_startServices$plugin = startServices().plugins.licensing) === null || _startServices$plugin === void 0 ? void 0 : _startServices$plugin.license$.pipe().subscribe(license => {
            isGold = license.hasAtLeast('gold');
          });
          return isGold;
        }
      }));
    }
    visualizations.registerAlias(_vis_type_alias.lensVisTypeAlias);
    uiActionsEnhanced.registerDrilldown(new _open_in_discover_drilldown.OpenInDiscoverDrilldown({
      dataViews: () => this.dataViewsService,
      locator: () => share === null || share === void 0 ? void 0 : share.url.locators.get('DISCOVER_APP_LOCATOR'),
      hasDiscoverAccess: () => this.hasDiscoverAccess,
      application: () => startServices().core.application
    }));
    contentManagement.registry.register({
      id: _content_management.CONTENT_ID,
      version: {
        latest: _content_management.LATEST_VERSION
      },
      name: _i18n.i18n.translate('xpack.lens.content.name', {
        defaultMessage: 'Lens Visualization'
      })
    });
    (0, _expressions.setupExpressions)(expressions, () => startServices().plugins.fieldFormats.deserialize, () => startServices().plugins.data.datatableUtilities, async () => {
      const {
        getTimeZone
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      return getTimeZone(core.uiSettings);
    }, () => startServices().plugins.data.nowProvider.get());
    core.application.register({
      id: _constants.APP_ID,
      title: _constants.NOT_INTERNATIONALIZED_PRODUCT_NAME,
      visibleIn: ['globalSearch'],
      category: _public5.DEFAULT_APP_CATEGORIES.kibana,
      euiIconType: 'logoKibana',
      mount: async params => {
        const {
          core: coreStart,
          plugins: deps
        } = startServices();
        const [{
          mountApp,
          getLensAttributeService,
          setUsageCollectionStart,
          initMemoizedErrorNotification
        }] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./async_services'))), this.initParts(core, data, charts, expressions, fieldFormats, deps.fieldFormats.deserialize)]);
        if (deps.usageCollection) {
          setUsageCollectionStart(deps.usageCollection);
        }
        initMemoizedErrorNotification(coreStart);
        const frameStart = this.editorFrameService.start(coreStart, deps);
        return mountApp(core, params, {
          createEditorFrame: frameStart.createInstance,
          attributeService: getLensAttributeService(coreStart, deps),
          topNavMenuEntryGenerators: this.topNavMenuEntries,
          locator: this.locator
        });
      }
    });
    urlForwarding.forwardApp(_constants.APP_ID, _constants.APP_ID);

    // Note: this overwrites a method defined above
    this.initEditorFrameService = async () => {
      if (this.datasourceMap && this.visualizationMap) {
        return {
          datasourceMap: this.datasourceMap,
          visualizationMap: this.visualizationMap
        };
      }
      const {
        plugins
      } = startServices();
      await this.initParts(core, data, charts, expressions, fieldFormats, plugins.fieldFormats.deserialize);
      // This needs to be executed before the import call to avoid race conditions
      const [visualizationMap, datasourceMap] = await Promise.all([this.editorFrameService.loadVisualizations(), this.editorFrameService.loadDatasources()]);
      this.visualizationMap = visualizationMap;
      this.datasourceMap = datasourceMap;
      return {
        datasourceMap,
        visualizationMap
      };
    };
    return {
      registerVisualization: vis => {
        if (this.editorFrameSetup) {
          this.editorFrameSetup.registerVisualization(vis);
        } else {
          // queue visualizations if editor frame is not yet ready as it's loaded async
          this.queuedVisualizations.push(vis);
        }
      },
      registerTopNavMenuEntryGenerator: menuEntryGenerator => {
        this.topNavMenuEntries.push(menuEntryGenerator);
      }
    };
  }
  async initParts(core, data, charts, expressions, fieldFormats, formatFactory) {
    const {
      DatatableVisualization,
      EditorFrameService,
      FormBasedDatasource,
      XyVisualization,
      LegacyMetricVisualization,
      MetricVisualization,
      PieVisualization,
      HeatmapVisualization,
      GaugeVisualization,
      TagcloudVisualization,
      TextBasedDatasource
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
    this.datatableVisualization = new DatatableVisualization();
    this.editorFrameService = new EditorFrameService();
    this.FormBasedDatasource = new FormBasedDatasource();
    this.TextBasedDatasource = new TextBasedDatasource();
    this.xyVisualization = new XyVisualization();
    this.legacyMetricVisualization = new LegacyMetricVisualization();
    this.metricVisualization = new MetricVisualization();
    this.pieVisualization = new PieVisualization();
    this.heatmapVisualization = new HeatmapVisualization();
    this.gaugeVisualization = new GaugeVisualization();
    this.tagcloudVisualization = new TagcloudVisualization();
    const editorFrameSetupInterface = this.editorFrameService.setup();
    const dependencies = {
      expressions,
      data,
      fieldFormats,
      charts,
      editorFrame: editorFrameSetupInterface,
      formatFactory
    };
    this.FormBasedDatasource.setup(core, dependencies);
    this.TextBasedDatasource.setup(core, dependencies);
    this.xyVisualization.setup(core, dependencies);
    this.datatableVisualization.setup(core, dependencies);
    this.legacyMetricVisualization.setup(core, dependencies);
    this.metricVisualization.setup(core, dependencies);
    this.pieVisualization.setup(core, dependencies);
    this.heatmapVisualization.setup(core, dependencies);
    this.gaugeVisualization.setup(core, dependencies);
    this.tagcloudVisualization.setup(core, dependencies);
    this.queuedVisualizations.forEach(queuedVis => {
      editorFrameSetupInterface.registerVisualization(queuedVis);
    });
    this.editorFrameSetup = editorFrameSetupInterface;
  }
  start(core, startDependencies) {
    var _startDependencies$sh;
    this.hasDiscoverAccess = core.application.capabilities.discover_v2.show;
    this.dataViewsService = startDependencies.dataViews;
    // unregisters the Visualize action and registers the lens one
    if (startDependencies.uiActions.hasAction(_public4.ACTION_VISUALIZE_FIELD)) {
      startDependencies.uiActions.unregisterAction(_public4.ACTION_VISUALIZE_FIELD);
    }

    // this trigger enables external consumers to use the inline editing flyout
    startDependencies.uiActions.registerTrigger(_in_app_embeddable_edit_trigger.inAppEmbeddableEditTrigger);
    startDependencies.uiActions.addTriggerActionAsync(_public4.VISUALIZE_FIELD_TRIGGER, _public4.ACTION_VISUALIZE_LENS_FIELD, async () => {
      const {
        visualizeFieldAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      return visualizeFieldAction(core.application);
    });
    startDependencies.uiActions.addTriggerActionAsync(_public3.VISUALIZE_EDITOR_TRIGGER, _public3.ACTION_CONVERT_TO_LENS, async () => {
      const {
        visualizeTSVBAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      return visualizeTSVBAction(core.application);
    });
    startDependencies.uiActions.addTriggerActionAsync(_public3.DASHBOARD_VISUALIZATION_PANEL_TRIGGER, _public3.ACTION_CONVERT_DASHBOARD_PANEL_TO_LENS, async () => {
      const {
        convertToLensActionFactory
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      const action = convertToLensActionFactory(_public3.ACTION_CONVERT_DASHBOARD_PANEL_TO_LENS, _i18n.i18n.translate('xpack.lens.visualizeLegacyVisualizationChart', {
        defaultMessage: 'Visualize legacy visualization chart'
      }), _i18n.i18n.translate('xpack.lens.dashboardLabel', {
        defaultMessage: 'Dashboard'
      }));
      return action(core.application);
    });
    startDependencies.uiActions.addTriggerActionAsync(_public3.AGG_BASED_VISUALIZATION_TRIGGER, _public3.ACTION_CONVERT_AGG_BASED_TO_LENS, async () => {
      const {
        convertToLensActionFactory
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      const action = convertToLensActionFactory(_public3.ACTION_CONVERT_AGG_BASED_TO_LENS, _i18n.i18n.translate('xpack.lens.visualizeAggBasedLegend', {
        defaultMessage: 'Visualize agg based chart'
      }), _i18n.i18n.translate('xpack.lens.AggBasedLabel', {
        defaultMessage: 'aggregation based visualization'
      }));
      return action(core.application);
    });

    // Allows the Lens embeddable to easily open the inline editing flyout
    // });
    // embeddable inline edit panel action
    // startDependencies.uiActions.addTriggerAction(
    //   IN_APP_EMBEDDABLE_EDIT_TRIGGER,
    //   editLensEmbeddableAction
    // );

    startDependencies.uiActions.addTriggerActionAsync(_constants2.IN_APP_EMBEDDABLE_EDIT_TRIGGER, _constants2.ACTION_EDIT_LENS_EMBEDDABLE, async () => {
      const {
        EditLensEmbeddableAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      const {
        visualizationMap,
        datasourceMap
      } = await this.initEditorFrameService();
      return new EditLensEmbeddableAction(core, {
        ...startDependencies,
        visualizationMap,
        datasourceMap
      });
    });
    startDependencies.uiActions.addTriggerActionAsync(_public4.ADD_PANEL_TRIGGER, _constants2.ACTION_CREATE_ESQL_CHART, async () => {
      const {
        AddESQLPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      return new AddESQLPanelAction(core);
    });
    startDependencies.uiActions.registerActionAsync('addLensPanelAction', async () => {
      const {
        getAddLensPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      return getAddLensPanelAction(startDependencies);
    });
    startDependencies.uiActions.attachAction(_public4.ADD_PANEL_TRIGGER, 'addLensPanelAction');
    if (startDependencies.uiActions.hasTrigger('ADD_CANVAS_ELEMENT_TRIGGER')) {
      // Because Canvas is not enabled in Serverless, this trigger might not be registered - only attach
      // the create action if the Canvas-specific trigger does indeed exist.
      startDependencies.uiActions.attachAction('ADD_CANVAS_ELEMENT_TRIGGER', 'addLensPanelAction');
    }
    const discoverLocator = (_startDependencies$sh = startDependencies.share) === null || _startDependencies$sh === void 0 ? void 0 : _startDependencies$sh.url.locators.get('DISCOVER_APP_LOCATOR');
    if (discoverLocator) {
      startDependencies.uiActions.addTriggerAction(_public2.CONTEXT_MENU_TRIGGER, (0, _open_in_discover_action.createOpenInDiscoverAction)(discoverLocator, startDependencies.dataViews, this.hasDiscoverAccess));
    }
    return {
      EmbeddableComponent: _lens_custom_renderer_component.LensRenderer,
      SaveModalComponent: (0, _saved_modal_lazy.getSaveModalComponent)(core, startDependencies),
      navigateToPrefilledEditor: (input, {
        openInNewTab = false,
        originatingApp = '',
        originatingPath,
        skipAppLeave = false
      } = {}) => {
        // for openInNewTab, we set the time range in url via getEditPath below
        if (input !== null && input !== void 0 && input.timeRange && !openInNewTab) {
          startDependencies.data.query.timefilter.timefilter.setTime(input.timeRange);
        }
        const transfer = new _public2.EmbeddableStateTransfer(core.application.navigateToApp, core.application.currentAppId$);
        transfer.navigateToEditor(_constants.APP_ID, {
          openInNewTab,
          path: (0, _constants.getEditPath)(undefined, openInNewTab && (input === null || input === void 0 ? void 0 : input.timeRange) || undefined),
          state: {
            originatingApp,
            originatingPath,
            valueInput: input
          },
          skipAppLeave
        });
      },
      canUseEditor: () => {
        var _core$application$cap;
        return Boolean((_core$application$cap = core.application.capabilities.visualize_v2) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show);
      },
      getXyVisTypes: async () => {
        const {
          visualizationSubtypes
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
        return visualizationSubtypes;
      },
      stateHelperApi: async () => {
        const [{
          createFormulaPublicApi,
          createChartInfoApi,
          suggestionsApi
        }, {
          visualizationMap,
          datasourceMap
        }] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./async_services'))), this.initEditorFrameService()]);
        return {
          formula: createFormulaPublicApi(),
          chartInfo: createChartInfoApi(startDependencies.dataViews, visualizationMap, datasourceMap),
          suggestions: (context, dataView, excludedVisualizations, preferredChartType, preferredVisAttributes) => {
            return suggestionsApi({
              datasourceMap,
              visualizationMap,
              context,
              dataView,
              excludedVisualizations,
              preferredChartType,
              preferredVisAttributes
            });
          }
        };
      },
      // TODO: remove this in faviour of the custom action thing
      // This is currently used in Discover by the unified histogram plugin
      EditLensConfigPanelApi: async () => {
        const [{
          visualizationMap,
          datasourceMap
        }, {
          getEditLensConfiguration
        }] = await Promise.all([this.initEditorFrameService(), Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')))]);
        const Component = await getEditLensConfiguration(core, startDependencies, visualizationMap, datasourceMap);
        return Component;
      }
    };
  }
  stop() {}
}
exports.LensPlugin = LensPlugin;