"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FakeDimensionButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FakeDimensionButton = ({
  label
}) => /*#__PURE__*/_react.default.createElement("div", {
  css: (0, _react2.css)`
      display: flex;
      align-items: center;
      border-radius: ${_uiTheme.euiThemeVars.euiBorderRadius};
      min-height: ${_uiTheme.euiThemeVars.euiSizeXL};

      cursor: default !important;
      background-color: ${_uiTheme.euiThemeVars.euiColorLightShade} !important;
      border-color: transparent !important;
      box-shadow: none !important;
      padding: 0 ${_uiTheme.euiThemeVars.euiSizeS};
    `
}, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DimensionTrigger, {
  label: label,
  id: "lns-fakeDimension",
  dataTestSubj: "lns-fakeDimension"
}));
exports.FakeDimensionButton = FakeDimensionButton;